/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.google.common.io.CountingOutputStream;
import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.execution.HttpClientResponseProperty;
import com.intellij.httpClient.execution.HttpProtocolUsage;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.RestClientResponse;
import com.intellij.httpClient.execution.RestClientResponseImpl;
import com.intellij.httpClient.execution.adapters.HttpClientBasicHeader;
import com.intellij.httpClient.execution.adapters.HttpClientContentType;
import com.intellij.httpClient.execution.adapters.HttpClientResponse;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.auth.HttpRequestAuthCredentials;
import com.intellij.httpClient.execution.auth.HttpRequestAuthScope;
import com.intellij.httpClient.execution.common.CommonClientResponseBody;
import com.intellij.httpClient.execution.common.CommonClientResponseProperty;
import com.intellij.httpClient.execution.impl.HttpClientBodyFileHint;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerHelper;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerUtil;
import com.intellij.httpClient.execution.impl.engineV2.HttpClientCookieJar;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2Kt;
import com.intellij.httpClient.execution.impl.engineV2.HttpRequestHandlerV2Kt$restClientResponse$1$invoke$;
import com.intellij.httpClient.execution.impl.engineV2.NettyAdaptersKt;
import com.intellij.httpClient.execution.impl.engineV2.NettyHttpClientKt;
import com.intellij.httpClient.execution.impl.engineV2.NettyHttpResponseAdapter;
import com.intellij.httpClient.execution.impl.engineV2.RawResponseInfoHolder;
import com.intellij.httpClient.execution.impl.engineV2.RedirectionChecker;
import com.intellij.httpClient.http.request.HttpClientCoroutinesService;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import kotlinx.coroutines.reactor.ConvertKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.util.context.Context;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\bH\u0002\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a$\u0010\u0014\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a6\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u0006\u0012\u0002\b\u00030\"2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006'"}, d2={"HTTP_CLIENT_AGENT", "", "fullHttpClientUserAgent", "getFullHttpClientUserAgent", "()Ljava/lang/String;", "decodeBrotli", "Lreactor/netty/ByteBufFlux;", "resp", "Lreactor/netty/http/client/HttpClientResponse;", "body", "getRedirects", "", "Ljava/net/URI;", "response", "asHttpProtocol", "Lcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;", "Lio/netty/handler/codec/http/HttpVersion;", "buildFullUrl", "Ljava/net/URL;", "Lcom/intellij/httpClient/execution/RestClientRequest;", "configureRedirects", "Lreactor/netty/http/client/HttpClient;", "method", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "cookieJar", "Lcom/intellij/httpClient/execution/impl/engineV2/HttpClientCookieJar;", "countBytes", "", "charset", "Ljava/nio/charset/Charset;", "restClientResponse", "Lreactor/core/publisher/Flux;", "Lcom/intellij/httpClient/execution/RestClientResponse;", "Lreactor/netty/http/client/HttpClient$ResponseReceiver;", "request", "cookies", "requestExecutionScope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nHttpRequestHandlerV2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequestHandlerV2.kt\ncom/intellij/httpClient/execution/impl/engineV2/HttpRequestHandlerV2Kt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,473:1\n1#2:474\n*E\n"})
public final class HttpRequestHandlerV2Kt {
    @NotNull
    private static final String HTTP_CLIENT_AGENT = "IntelliJ HTTP Client";

    private static final Flux<RestClientResponse> restClientResponse(HttpClient.ResponseReceiver<?> $this$restClientResponse, RestClientRequest request2, HttpClientCookieJar cookies, CoroutineScope requestExecutionScope, HttpRequestConfig config) {
        Flux<RestClientResponse> flux = $this$restClientResponse.response((arg_0, arg_1) -> HttpRequestHandlerV2Kt.restClientResponse$lambda$0((Function2)new Function2<reactor.netty.http.client.HttpClientResponse, ByteBufFlux, Publisher<RestClientResponse>>(cookies, requestExecutionScope, request2){
            final /* synthetic */ HttpClientCookieJar $cookies;
            final /* synthetic */ CoroutineScope $requestExecutionScope;
            final /* synthetic */ RestClientRequest $request;
            {
                this.$cookies = $cookies;
                this.$requestExecutionScope = $requestExecutionScope;
                this.$request = $request;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final Publisher<RestClientResponse> invoke(reactor.netty.http.client.HttpClientResponse resp, ByteBufFlux body2) {
                Flux<RestClientResponse> flux;
                RawResponseInfoHolder rawResponseInfoHolder = (RawResponseInfoHolder)resp.currentContextView().get(RawResponseInfoHolder.Key);
                HttpVersion httpVersion = rawResponseInfoHolder.getProtocol();
                if (httpVersion == null) {
                    httpVersion = resp.version();
                }
                HttpVersion version = httpVersion;
                Intrinsics.checkNotNull((Object)resp);
                Intrinsics.checkNotNull((Object)version);
                NettyHttpResponseAdapter httpClientResponse = new NettyHttpResponseAdapter(resp, NettyHttpClientKt.normalizedProtocolPresentation(version));
                HttpClientContentType contentType2 = httpClientResponse.getContentType();
                String string = resp.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                Long contentLength = string != null ? StringsKt.toLongOrNull((String)string) : null;
                HttpClientBodyFileHint fileHint = new HttpClientBodyFileHint(httpClientResponse.getHeader("Content-Disposition"), contentType2.getMimeType());
                this.$cookies.addCookies(NettyAdaptersKt.biscuits(resp));
                if (HttpRequestHandlerUtil.isTextContentType(contentType2) && !HttpRequestHandlerUtil.isTextStream(contentType2.getMimeType())) {
                    Charset charset = contentType2.getCharset();
                    if (charset == null) {
                        charset = HttpRequestHandlerUtil.guessCharset(contentType2.getMimeType());
                    }
                    encoding = charset;
                    Intrinsics.checkNotNull((Object)body2);
                    flux = HttpRequestHandlerV2Kt.access$decodeBrotli(resp, body2).aggregate().asString(encoding).map(arg_0 -> restClientResponse.1.invoke$lambda$0((Function1)new Function1<String, RestClientResponse>(httpClientResponse, fileHint, encoding, contentType2){
                        final /* synthetic */ NettyHttpResponseAdapter $httpClientResponse;
                        final /* synthetic */ HttpClientBodyFileHint $fileHint;
                        final /* synthetic */ Charset $encoding;
                        final /* synthetic */ HttpClientContentType $contentType;
                        {
                            this.$httpClientResponse = $httpClientResponse;
                            this.$fileHint = $fileHint;
                            this.$encoding = $encoding;
                            this.$contentType = $contentType;
                            super(1);
                        }

                        public final RestClientResponse invoke(String text2) {
                            RestClientResponse restClientResponse2;
                            Intrinsics.checkNotNull((Object)text2);
                            if (((CharSequence)text2).length() == 0) {
                                restClientResponse2 = RestClientResponseImpl.createFromBody(this.$httpClientResponse, new CommonClientResponseBody.Empty(this.$fileHint));
                            } else {
                                HttpClientResponse httpClientResponse = this.$httpClientResponse;
                                String string = HttpRequestHandlerHelper.cleanBody(text2, this.$encoding, this.$contentType.getMimeType());
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cleanBody(...)");
                                restClientResponse2 = RestClientResponseImpl.createFromBody(httpClientResponse, new CommonClientResponseBody.Text(string, this.$fileHint));
                            }
                            return restClientResponse2;
                        }
                    }, arg_0)).defaultIfEmpty(RestClientResponseImpl.createEmptyResponse(httpClientResponse)).flux();
                } else if (HttpRequestHandlerUtil.isTextStream(contentType2.getMimeType())) {
                    void $this$map$iv;
                    Charset charset = contentType2.getCharset();
                    if (charset == null) {
                        charset = HttpRequestHandlerUtil.guessCharset(contentType2.getMimeType());
                    }
                    encoding = charset;
                    CompletableDeferred streamReadingComplete = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                    Flux<String> flux2 = body2.asString(encoding);
                    Intrinsics.checkNotNullExpressionValue(flux2, (String)"asString(...)");
                    Flow<T> flow = ReactiveFlowKt.asFlow(flux2);
                    boolean $i$f$map = false;
                    void $this$unsafeTransform$iv$iv = $this$map$iv;
                    boolean $i$f$unsafeTransform = false;
                    boolean $i$f$unsafeFlow = false;
                    SharedFlow stream2 = FlowKt.shareIn((Flow)FlowKt.onCompletion((Flow)FlowKt.catch((Flow)((Flow)new Flow<CommonClientResponseBody.TextStream.Message>((Flow)$this$unsafeTransform$iv$iv, encoding, contentType2){
                        final /* synthetic */ Flow $this_unsafeTransform$inlined;
                        final /* synthetic */ Charset $encoding$inlined;
                        final /* synthetic */ HttpClientContentType $contentType$inlined;
                        {
                            this.$this_unsafeTransform$inlined = flow;
                            this.$encoding$inlined = charset;
                            this.$contentType$inlined = httpClientContentType;
                        }

                        @Nullable
                        public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                            Continuation continuation = $completion;
                            FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                            boolean bl = false;
                            Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.$encoding$inlined, this.$contentType$inlined){
                                final /* synthetic */ FlowCollector $this_unsafeFlow;
                                final /* synthetic */ Charset $encoding$inlined;
                                final /* synthetic */ HttpClientContentType $contentType$inlined;
                                {
                                    this.$this_unsafeFlow = $receiver;
                                    this.$encoding$inlined = charset;
                                    this.$contentType$inlined = httpClientContentType;
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                    if (!(var2_2 instanceof restClientResponse$1$invoke$$inlined$map$1$2$1)) ** GOTO lbl-1000
                                    var3_3 = var2_2;
                                    if ((var3_3.label & -2147483648) != 0) {
                                        var3_3.label -= -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        $continuation = new ContinuationImpl(this, var2_2){
                                            /* synthetic */ Object result;
                                            int label;
                                            Object L$0;
                                            final /* synthetic */ restClientResponse$1$invoke$$inlined$map$1$2 this$0;
                                            {
                                                this.this$0 = this$0;
                                                super($completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object $result) {
                                                this.result = $result;
                                                this.label |= Integer.MIN_VALUE;
                                                return this.this$0.emit(null, (Continuation)this);
                                            }
                                        };
                                    }
                                    $result = $continuation.result;
                                    var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch ($continuation.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var6_6 = value;
                                            $this$map_u24lambda_u245 = this.$this_unsafeFlow;
                                            $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                            var9_10 = $this$map_u24lambda_u245;
                                            (Continuation)$continuation;
                                            chunk = (String)value;
                                            $i$a$-map-HttpRequestHandlerV2Kt$restClientResponse$1$response$stream$1 = false;
                                            v0 = HttpRequestHandlerHelper.cleanBody(chunk, this.$encoding$inlined, this.$contentType$inlined.getMimeType());
                                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"cleanBody(...)");
                                            $continuation.label = 1;
                                            v1 = var9_10.emit((Object)new CommonClientResponseBody.TextStream.Message.Content.Chunk(v0), (Continuation)$continuation);
                                            if (v1 == var5_5) {
                                                return var5_5;
                                            }
                                            ** GOTO lbl31
                                        }
                                        case 1: {
                                            $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl31:
                                            // 2 sources

                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                            }, $completion);
                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object;
                            }
                            return Unit.INSTANCE;
                        }
                    }), (Function3)((Function3)new Function3<FlowCollector<? super CommonClientResponseBody.TextStream.Message>, Throwable, Continuation<? super Unit>, Object>((CompletableDeferred<Unit>)streamReadingComplete, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        /* synthetic */ Object L$1;
                        final /* synthetic */ CompletableDeferred<Unit> $streamReadingComplete;
                        {
                            this.$streamReadingComplete = $streamReadingComplete;
                            super(3, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$catch = (FlowCollector)this.L$0;
                                    e = (Throwable)this.L$1;
                                    this.L$0 = null;
                                    this.label = 1;
                                    v0 = $this$catch.emit((Object)new CommonClientResponseBody.TextStream.Message.ConnectionClosed.WithError(e), (Continuation)this);
                                    if (v0 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    this.$streamReadingComplete.complete((Object)Unit.INSTANCE);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Nullable
                        public final Object invoke(@NotNull FlowCollector<? super CommonClientResponseBody.TextStream.Message> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                            var var4_4 = new /* invalid duplicate definition of identical inner class */;
                            var4_4.L$0 = p1;
                            var4_4.L$1 = p2;
                            return var4_4.invokeSuspend(Unit.INSTANCE);
                        }
                    })), (Function3)((Function3)new Function3<FlowCollector<? super CommonClientResponseBody.TextStream.Message>, Throwable, Continuation<? super Unit>, Object>((CompletableDeferred<Unit>)streamReadingComplete, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        /* synthetic */ Object L$1;
                        final /* synthetic */ CompletableDeferred<Unit> $streamReadingComplete;
                        {
                            this.$streamReadingComplete = $streamReadingComplete;
                            super(3, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$onCompletion = (FlowCollector)this.L$0;
                                    e = (Throwable)this.L$1;
                                    if (e != null) ** GOTO lbl19
                                    this.L$0 = null;
                                    this.label = 1;
                                    v0 = $this$onCompletion.emit((Object)CommonClientResponseBody.TextStream.Message.ConnectionClosed.End.INSTANCE, (Continuation)this);
                                    if (v0 == var4_2) {
                                        return var4_2;
                                    }
                                    ** GOTO lbl17
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl17:
                                    // 2 sources

                                    this.$streamReadingComplete.complete((Object)Unit.INSTANCE);
lbl19:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Nullable
                        public final Object invoke(@NotNull FlowCollector<? super CommonClientResponseBody.TextStream.Message> p1, @Nullable Throwable p2, @Nullable Continuation<? super Unit> p3) {
                            var var4_4 = new /* invalid duplicate definition of identical inner class */;
                            var4_4.L$0 = p1;
                            var4_4.L$1 = p2;
                            return var4_4.invokeSuspend(Unit.INSTANCE);
                        }
                    })), (CoroutineScope)HttpClientCoroutinesService.Companion.getInstance$default(HttpClientCoroutinesService.Companion, null, 1, null).scope((CoroutineContext)new CoroutineName("Text stream socket reading")), (SharingStarted)SharingStarted.Companion.getLazily(), (int)100);
                    RestClientResponse restClientResponse2 = RestClientResponseImpl.createFromBody(httpClientResponse, new CommonClientResponseBody.TextStream((Flow)stream2, fileHint, null, 4, null));
                    Intrinsics.checkNotNullExpressionValue((Object)restClientResponse2, (String)"createFromBody(...)");
                    RestClientResponse response2 = restClientResponse2;
                    flux = Flux.just(response2).concatWith((Publisher<RestClientResponse>)ConvertKt.asMono((Deferred)streamReadingComplete, (CoroutineContext)Dispatchers.getDefault()).then(Mono.empty()));
                } else if (contentLength != null || !HttpRequestHandlerUtil.isPossiblyInfinite(httpClientResponse, contentType2.getMimeType())) {
                    CommonClientResponseBody.Binary.ContentDescriptor contentDescriptor2 = HttpRequestHandlerUtil.readBinaryBody$default(this.$requestExecutionScope, null, (Function3)new Function3<OutputStream, Function1<? super Integer, ? extends Unit>, Continuation<? super Unit>, Object>(body2, null){
                        int label;
                        /* synthetic */ Object L$0;
                        /* synthetic */ Object L$1;
                        final /* synthetic */ ByteBufFlux $body;
                        {
                            this.$body = $body;
                            super(3, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    OutputStream outputStream = (OutputStream)this.L$0;
                                    Function1 sizeAdder = (Function1)this.L$1;
                                    Flux<byte[]> flux = this.$body.asByteArray();
                                    Intrinsics.checkNotNullExpressionValue(flux, (String)"asByteArray(...)");
                                    this.L$0 = null;
                                    this.label = 1;
                                    Object object3 = ReactiveFlowKt.asFlow(flux).collect(new FlowCollector((Function1<? super Integer, Unit>)sizeAdder, outputStream){
                                        final /* synthetic */ Function1<Integer, Unit> $sizeAdder;
                                        final /* synthetic */ OutputStream $outputStream;
                                        {
                                            this.$sizeAdder = $sizeAdder;
                                            this.$outputStream = $outputStream;
                                        }

                                        @Nullable
                                        public final Object emit(byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
                                            this.$sizeAdder.invoke((Object)Boxing.boxInt((int)bytes.length));
                                            this.$outputStream.write(bytes);
                                            return Unit.INSTANCE;
                                        }
                                    }, (Continuation)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @Nullable
                        public final Object invoke(@NotNull OutputStream p1, @NotNull Function1<? super Integer, Unit> p2, @Nullable Continuation<? super Unit> p3) {
                            var var4_4 = new /* invalid duplicate definition of identical inner class */;
                            var4_4.L$0 = p1;
                            var4_4.L$1 = p2;
                            return var4_4.invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                    CommonClientResponseBody.Binary body3 = new CommonClientResponseBody.Binary(contentDescriptor2, contentLength, fileHint);
                    flux = Flux.just(RestClientResponseImpl.createFromBody(httpClientResponse, body3)).concatWith((Publisher<RestClientResponse>)ConvertKt.asMono(contentDescriptor2.getContent(), (CoroutineContext)Dispatchers.getDefault()).then(Mono.empty()));
                } else {
                    flux = Flux.just(RestClientResponseImpl.createEmptyResponse("Unsupported response"));
                }
                Flux<RestClientResponse> response3 = flux;
                return response3.map(arg_0 -> restClientResponse.1.invoke$lambda$2((Function1)new Function1<RestClientResponse, RestClientResponse>(rawResponseInfoHolder, resp, this.$request, version){
                    final /* synthetic */ RawResponseInfoHolder $rawResponseInfoHolder;
                    final /* synthetic */ reactor.netty.http.client.HttpClientResponse $resp;
                    final /* synthetic */ RestClientRequest $request;
                    final /* synthetic */ HttpVersion $version;
                    {
                        this.$rawResponseInfoHolder = $rawResponseInfoHolder;
                        this.$resp = $resp;
                        this.$request = $request;
                        this.$version = $version;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final RestClientResponse invoke(RestClientResponse res) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        void $this$mapTo$iv$iv2;
                        void $this$map$iv2;
                        List list2 = this.$rawResponseInfoHolder.getHeaders();
                        if (list2 == null) {
                            list2 = this.$resp.responseHeaders().entries();
                        }
                        Object object = list2;
                        Intrinsics.checkNotNull(object);
                        object = (Iterable)object;
                        RestClientResponse restClientResponse2 = res;
                        boolean $i$f$map = false;
                        reactor.netty.http.client.HttpClientResponse httpClientResponse = $this$map$iv2;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv2) {
                            void it;
                            Map.Entry entry = (Map.Entry)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl2 = false;
                            collection.add(HttpClientBasicHeader.Companion.create((String)it.getKey(), (String)it.getValue()));
                        }
                        RestClientResponse restClientResponse3 = restClientResponse2.withHeaders((List)destination$iv$iv);
                        CommonClientResponseProperty commonClientResponseProperty = HttpClientResponseProperty.RedirectionPath.INSTANCE;
                        reactor.netty.http.client.HttpClientResponse httpClientResponse2 = this.$resp;
                        Intrinsics.checkNotNullExpressionValue((Object)httpClientResponse2, (String)"$resp");
                        RestClientResponse restClientResponse4 = restClientResponse3.withAdditionalProperty(commonClientResponseProperty, HttpRequestHandlerV2Kt.access$getRedirects(httpClientResponse2));
                        CommonClientResponseProperty commonClientResponseProperty2 = HttpClientResponseProperty.ProtocolUsed.INSTANCE;
                        RequestBuilder.HttpProtocol httpProtocol = this.$request.protocol;
                        HttpVersion httpVersion = this.$version;
                        Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"$version");
                        object = restClientResponse4.withAdditionalProperty(commonClientResponseProperty2, new HttpProtocolUsage(httpProtocol, HttpRequestHandlerV2Kt.access$asHttpProtocol(httpVersion)));
                        RestClientRequest restClientRequest = this.$request;
                        httpClientResponse = this.$resp;
                        Object it = object;
                        boolean bl = false;
                        HttpHeaders httpHeaders = httpClientResponse.requestHeaders();
                        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"requestHeaders(...)");
                        Iterable iterable = (Iterable)httpHeaders;
                        RestClientRequest restClientRequest2 = restClientRequest;
                        boolean $i$f$map2 = false;
                        void bl2 = $this$map$iv;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it2;
                            Map.Entry entry = (Map.Entry)item$iv$iv;
                            Collection collection = destination$iv$iv2;
                            boolean bl3 = false;
                            collection.add(new RestClientRequest.KeyValuePair((String)it2.getKey(), (String)it2.getValue()));
                        }
                        restClientRequest2.setActualSentHeaders((List)destination$iv$iv2);
                        return object;
                    }
                }, arg_0));
            }

            private static final RestClientResponse invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (RestClientResponse)$tmp0.invoke(p0);
            }

            private static final RestClientResponse invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (RestClientResponse)$tmp0.invoke(p0);
            }
        }, arg_0, arg_1)).contextWrite(arg_0 -> HttpRequestHandlerV2Kt.restClientResponse$lambda$1(request2, config, arg_0));
        Intrinsics.checkNotNullExpressionValue(flux, (String)"contextWrite(...)");
        return flux;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<URI> getRedirects(reactor.netty.http.client.HttpClientResponse response2) {
        Object[] redirectedFrom = response2.redirectedFrom();
        Intrinsics.checkNotNull((Object)redirectedFrom);
        if (redirectedFrom.length == 0) {
            return CollectionsKt.emptyList();
        }
        String string = response2.resourceUrl();
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String finalUrl = string;
        int n = redirectedFrom.length;
        ArrayList<URI> arrayList = new ArrayList<URI>(n);
        for (int i = 0; i < n; ++i) {
            void it;
            int n2;
            int n3 = n2 = i;
            ArrayList<URI> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(it < ArraysKt.getLastIndex((Object[])redirectedFrom) ? new URI((String)redirectedFrom[it + true]) : new URI(finalUrl));
        }
        return arrayList;
    }

    private static final ByteBufFlux decodeBrotli(reactor.netty.http.client.HttpClientResponse resp, ByteBufFlux body2) {
        if (!Intrinsics.areEqual((Object)resp.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING), (Object)"br")) {
            return body2;
        }
        ByteBufFlux byteBufFlux = ByteBufFlux.fromInbound((Publisher)body2.aggregate().map(arg_0 -> HttpRequestHandlerV2Kt.decodeBrotli$lambda$3(decodeBrotli.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue((Object)byteBufFlux, (String)"fromInbound(...)");
        return byteBufFlux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long countBytes(String $this$countBytes, Charset charset) {
        CountingOutputStream countingStream = new CountingOutputStream(OutputStream.nullOutputStream());
        Closeable closeable = new OutputStreamWriter((OutputStream)countingStream, charset);
        Throwable throwable = null;
        try {
            OutputStreamWriter writer = (OutputStreamWriter)closeable;
            boolean bl = false;
            writer.write($this$countBytes);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return countingStream.getCount();
    }

    private static final URL buildFullUrl(RestClientRequest $this$buildFullUrl) {
        Object[] objectArray;
        String it;
        String string;
        URL url = new URL(HttpRequestHandlerHelper.getFullUri($this$buildFullUrl.getURL(), $this$buildFullUrl));
        if (url.getUserInfo() == null) {
            return url;
        }
        String string2 = url.getUserInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserInfo(...)");
        Object object = new String[]{":"};
        List usernameAndPassword = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)2, (int)2, null);
        HttpRequestAuthScope httpRequestAuthScope = new HttpRequestAuthScope("Basic");
        String string3 = (String)usernameAndPassword.get(0);
        String string4 = (String)CollectionsKt.getOrNull((List)usernameAndPassword, (int)1);
        if (string4 == null) {
            string4 = "";
        }
        $this$buildFullUrl.authData = new HttpClientAuthData(httpRequestAuthScope, new HttpRequestAuthCredentials.UsernamePassword(string3, string4));
        Object $this$buildFullUrl_u24lambda_u2410 = object = new StringBuilder();
        boolean bl = false;
        String string5 = string = url.getProtocol();
        if (string5 != null) {
            Intrinsics.checkNotNull((Object)string5);
            it = string;
            boolean bl2 = false;
            objectArray = new String[]{it, "://"};
            StringsKt.append((StringBuilder)$this$buildFullUrl_u24lambda_u2410, (String[])objectArray);
        }
        String string6 = string = url.getHost();
        if (string6 != null) {
            Intrinsics.checkNotNull((Object)string6);
            it = string;
            boolean bl3 = false;
            ((StringBuilder)$this$buildFullUrl_u24lambda_u2410).append(it);
        }
        Integer n = url.getPort();
        int it2 = ((Number)n).intValue();
        boolean bl4 = false;
        Integer n2 = it2 > 0 ? n : null;
        if (n2 != null) {
            it2 = ((Number)n2).intValue();
            boolean bl5 = false;
            objectArray = new Object[]{":", it2};
            StringsKt.append((StringBuilder)$this$buildFullUrl_u24lambda_u2410, (Object[])objectArray);
        }
        String string7 = string = url.getPath();
        if (string7 != null) {
            Intrinsics.checkNotNull((Object)string7);
            String it3 = string;
            boolean bl6 = false;
            if (!StringsKt.startsWith$default((String)it3, (String)"/", (boolean)false, (int)2, null)) {
                ((StringBuilder)$this$buildFullUrl_u24lambda_u2410).append("/");
            }
            ((StringBuilder)$this$buildFullUrl_u24lambda_u2410).append(it3);
        }
        String string8 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
        String string9 = string8;
        return new URL(string9);
    }

    private static final HttpClient configureRedirects(HttpClient $this$configureRedirects, String method, HttpRequestConfig config, HttpClientCookieJar cookieJar) {
        if (config.isFollowRedirects() && RedirectionChecker.Key.getLaxRedirectionMethods().contains(method)) {
            HttpClient httpClient = $this$configureRedirects.followRedirect((arg_0, arg_1) -> HttpRequestHandlerV2Kt.configureRedirects$lambda$11(cookieJar, arg_0, arg_1), arg_0 -> HttpRequestHandlerV2Kt.configureRedirects$lambda$12(cookieJar, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"followRedirect(...)");
            return httpClient;
        }
        return $this$configureRedirects;
    }

    private static final String getFullHttpClientUserAgent() {
        HttpRequestExecutionHelperService executionHelperService = HttpRequestExecutionHelperService.getInstance();
        if (executionHelperService == null) {
            return HTTP_CLIENT_AGENT;
        }
        String string = executionHelperService.productVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"productVersion(...)");
        String version = string;
        if (StringsKt.isBlank((CharSequence)version)) {
            return HTTP_CLIENT_AGENT;
        }
        return "IntelliJ HTTP Client/" + version;
    }

    private static final RequestBuilder.HttpProtocol asHttpProtocol(HttpVersion $this$asHttpProtocol) {
        return Intrinsics.areEqual((Object)$this$asHttpProtocol, (Object)HttpVersion.HTTP_1_1) ? RequestBuilder.HttpProtocol.HTTP_11 : (Intrinsics.areEqual((Object)$this$asHttpProtocol.protocolName(), (Object)"HTTP") && $this$asHttpProtocol.majorVersion() == 2 ? RequestBuilder.HttpProtocol.HTTP_2 : RequestBuilder.HttpProtocol.HTTP_11);
    }

    private static final Publisher restClientResponse$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0, p1);
    }

    private static final Context restClientResponse$lambda$1(RestClientRequest $request, HttpRequestConfig $config, Context it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        return it.put(RedirectionChecker.Key, RedirectionChecker.Key.fromRequestAndConfig$default(RedirectionChecker.Key, $request, $config, 0, 4, null)).put(RawResponseInfoHolder.Key, new RawResponseInfoHolder());
    }

    private static final ByteBuf decodeBrotli$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ByteBuf)$tmp0.invoke(p0);
    }

    private static final boolean configureRedirects$lambda$11(HttpClientCookieJar $cookieJar, HttpClientRequest req, reactor.netty.http.client.HttpClientResponse resp) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$cookieJar, (String)"$cookieJar");
        RedirectionChecker redirectionChecker = (RedirectionChecker)req.currentContextView().get(RedirectionChecker.Key);
        if (RedirectionChecker.Key.getRedirectionStatuses().contains(resp.status().code()) && redirectionChecker.redirectAvailable()) {
            Intrinsics.checkNotNull((Object)resp);
            $cookieJar.addCookies(NettyAdaptersKt.biscuits(resp));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final void configureRedirects$lambda$12(HttpClientCookieJar $cookieJar, HttpClientRequest req) {
        Intrinsics.checkNotNullParameter((Object)$cookieJar, (String)"$cookieJar");
        String cookieValue = NettyAdaptersKt.biscuitsToHeader($cookieJar.selectCookiesFor(new URL(req.resourceUrl())));
        if (cookieValue != null) {
            req.addHeader((CharSequence)HttpHeaderNames.COOKIE, cookieValue);
        }
    }

    public static final /* synthetic */ URL access$buildFullUrl(RestClientRequest $receiver) {
        return HttpRequestHandlerV2Kt.buildFullUrl($receiver);
    }

    public static final /* synthetic */ long access$countBytes(String $receiver, Charset charset) {
        return HttpRequestHandlerV2Kt.countBytes($receiver, charset);
    }

    public static final /* synthetic */ HttpClient access$configureRedirects(HttpClient $receiver, String method, HttpRequestConfig config, HttpClientCookieJar cookieJar) {
        return HttpRequestHandlerV2Kt.configureRedirects($receiver, method, config, cookieJar);
    }

    public static final /* synthetic */ String access$getFullHttpClientUserAgent() {
        return HttpRequestHandlerV2Kt.getFullHttpClientUserAgent();
    }

    public static final /* synthetic */ Flux access$restClientResponse(HttpClient.ResponseReceiver $receiver, RestClientRequest request2, HttpClientCookieJar cookies, CoroutineScope requestExecutionScope, HttpRequestConfig config) {
        return HttpRequestHandlerV2Kt.restClientResponse($receiver, request2, cookies, requestExecutionScope, config);
    }

    public static final /* synthetic */ ByteBufFlux access$decodeBrotli(reactor.netty.http.client.HttpClientResponse resp, ByteBufFlux body2) {
        return HttpRequestHandlerV2Kt.decodeBrotli(resp, body2);
    }

    public static final /* synthetic */ List access$getRedirects(reactor.netty.http.client.HttpClientResponse response2) {
        return HttpRequestHandlerV2Kt.getRedirects(response2);
    }

    public static final /* synthetic */ RequestBuilder.HttpProtocol access$asHttpProtocol(HttpVersion $receiver) {
        return HttpRequestHandlerV2Kt.asHttpProtocol($receiver);
    }
}

