/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution;

import com.intellij.codeWithMe.ClientId;
import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.MimeTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="HttpClientUserMimeTypeRegistry", storages={@Storage(value="http-client.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.TOOLS)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$MimeTypeMarks;", "()V", "markAs", "", "mimeType", "", "mark", "Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$MimeTypeMark;", "mimeTypeMark", "unmarkIf", "Companion", "MimeTypeMark", "MimeTypeMarks", "intellij.httpClient.executor"})
public final class HttpClientUserMimeTypeRegistry
extends SimplePersistentStateComponent<MimeTypeMarks> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public HttpClientUserMimeTypeRegistry() {
        super((BaseState)new MimeTypeMarks());
    }

    @Nullable
    public final MimeTypeMark mimeTypeMark(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Map<String, MimeTypeMark> map2 = ((MimeTypeMarks)this.getState()).getUserMarks();
        String string = mimeType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return map2.get(string);
    }

    public final void markAs(@NotNull String mimeType, @NotNull MimeTypeMark mark) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)((Object)mark), (String)"mark");
        Map<String, MimeTypeMark> map2 = ((MimeTypeMarks)this.getState()).getUserMarks();
        String string = mimeType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        map2.put(string, mark);
    }

    public final void unmarkIf(@NotNull String mimeType, @NotNull MimeTypeMark mark) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)((Object)mark), (String)"mark");
        Map<String, MimeTypeMark> map2 = ((MimeTypeMarks)this.getState()).getUserMarks();
        String string = mimeType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (map2.get(string) == mark) {
            Map<String, MimeTypeMark> map3 = ((MimeTypeMarks)this.getState()).getUserMarks();
            String string2 = mimeType.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            map3.remove(string2);
        }
    }

    @JvmStatic
    public static final boolean isPredefinedMimeType(@Nullable String mimeType) {
        return Companion.isPredefinedMimeType(mimeType);
    }

    @JvmStatic
    @NotNull
    public static final HttpClientUserMimeTypeRegistry getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$Companion;", "", "()V", "getInstance", "Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry;", "isPredefinedMimeType", "", "mimeType", "", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nHttpClientUserMimeTypeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientUserMimeTypeRegistry.kt\ncom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,67:1\n40#2,3:68\n*S KotlinDebug\n*F\n+ 1 HttpClientUserMimeTypeRegistry.kt\ncom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$Companion\n*L\n46#1:68,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPredefinedMimeType(@Nullable String mimeType) {
            String string;
            String string2 = mimeType;
            if (string2 != null) {
                String string3 = string2.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            return MimeTypes.PREDEFINED_MIME_VARIANTS.contains(string);
        }

        @JvmStatic
        @NotNull
        public final HttpClientUserMimeTypeRegistry getInstance() {
            boolean $i$f$service = false;
            Class<HttpClientUserMimeTypeRegistry> serviceClass$iv = HttpClientUserMimeTypeRegistry.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (HttpClientUserMimeTypeRegistry)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$MimeTypeMark;", "", "presentableName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPresentableName", "()Ljava/lang/String;", "JSON", "XML", "TEXT", "BINARY", "intellij.httpClient.executor"})
    public static final class MimeTypeMark
    extends Enum<MimeTypeMark> {
        @NotNull
        private final transient String presentableName;
        public static final /* enum */ MimeTypeMark JSON = new MimeTypeMark("JSON");
        public static final /* enum */ MimeTypeMark XML = new MimeTypeMark("XML");
        public static final /* enum */ MimeTypeMark TEXT = new MimeTypeMark(HttpClientExecutorBundle.message("http.request.mime.type.registry.text.name", new Object[0]));
        public static final /* enum */ MimeTypeMark BINARY = new MimeTypeMark(HttpClientExecutorBundle.message("http.request.mime.type.registry.binary.name", new Object[0]));
        private static final /* synthetic */ MimeTypeMark[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MimeTypeMark(String presentableName) {
            this.presentableName = presentableName;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        public static MimeTypeMark[] values() {
            return (MimeTypeMark[])$VALUES.clone();
        }

        public static MimeTypeMark valueOf(String value2) {
            return Enum.valueOf(MimeTypeMark.class, value2);
        }

        @NotNull
        public static EnumEntries<MimeTypeMark> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mimeTypeMarkArray = new MimeTypeMark[]{MimeTypeMark.JSON, MimeTypeMark.XML, MimeTypeMark.TEXT, MimeTypeMark.BINARY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$MimeTypeMarks;", "Lcom/intellij/openapi/components/BaseState;", "()V", "userMarks", "", "", "Lcom/intellij/httpClient/execution/HttpClientUserMimeTypeRegistry$MimeTypeMark;", "getUserMarks", "()Ljava/util/Map;", "userMarks$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.httpClient.executor"})
    public static final class MimeTypeMarks
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty userMarks$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        @XCollection(propertyElementName="userMarks", style=XCollection.Style.v2)
        @NotNull
        public final Map<String, MimeTypeMark> getUserMarks() {
            return (Map)this.userMarks$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MimeTypeMarks.class, "userMarks", "getUserMarks()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

