/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.actions.HttpClientConvertFromCurlDialog;
import com.intellij.httpClient.actions.OpenInScratchFileUtil;
import com.intellij.httpClient.converters.curl.Utils;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.converters.curl.parser.CurlParser;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ConvertCurlToHttpRequestAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(ConvertCurlToHttpRequestAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        String clipboard = ConvertCurlToHttpRequestAction.getClipboardContent();
        String initial = Utils.isCurlString(clipboard) ? clipboard : "curl -i http://httpbin.org/ip";
        HttpClientConvertFromCurlDialog dialog = new HttpClientConvertFromCurlDialog(project, initial);
        if (dialog.showAndGet()) {
            try {
                String text2 = dialog.getCurlText();
                RestClientRequest request2 = new CurlParser().parseToRestClientRequest(text2);
                VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
                if (selectedFiles.length > 0 && FileTypeRegistry.getInstance().isFileOfType(selectedFiles[0], (FileType)HttpRequestFileType.INSTANCE) && !HttpRequestFileUtils.isHttpRequestSystemFile(project, selectedFiles[0].getPath())) {
                    if (editor2 != null) {
                        Document document = editor2.getDocument();
                        editor2.getCaretModel().moveToOffset(0);
                        WriteCommandAction.runWriteCommandAction((Project)project, (String)RestClientBundle.message("http.request.convert.curl.ui.title", new Object[0]), null, () -> document.insertString(0, (CharSequence)(Utils.createCurlStringComment(text2) + HttpRequestPsiConverter.toPsiHttpRequest(request2))), (PsiFile[])new PsiFile[0]);
                    }
                } else {
                    OpenInScratchFileUtil.createAndOpenScratchFile(project, request2, Utils.createCurlStringComment(text2));
                }
            }
            catch (CurlParseException ex) {
                Messages.showErrorDialog((Project)project, (String)ex.getMessage(), (String)RestClientBundle.message("http.request.convert.curl.to.http.request.failed.title", new Object[0]));
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ConvertCurlToHttpRequestAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    private static String getClipboardContent() {
        block3: {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                if (contents == null) break block3;
                string = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException e1) {
                LOG.warn("Failed getting clipboard content");
            }
            if (string == null) {
                ConvertCurlToHttpRequestAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/ConvertCurlToHttpRequestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/ConvertCurlToHttpRequestAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClipboardContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

