/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import org.apache.commons.numbers.core.ExtendedPrecision;
import org.apache.commons.numbers.core.Sum;

public enum Norm {
    L1(Norm::manhattan, Norm::manhattan, Norm::manhattan),
    MANHATTAN(L1),
    L2(Norm::euclidean, Norm::euclidean, Norm::euclidean),
    EUCLIDEAN(L2),
    LINF(Norm::maximum, Norm::maximum, Norm::maximum),
    MAXIMUM(LINF);

    private static final double SMALL_THRESH = 1.4916681462400413E-154;
    private static final double LARGE_THRESH = 2.0458691299350887E149;
    private static final double SAFE_SCALE_UP_THRESH = 7.888609052210118E-31;
    private static final double SCALE_DOWN = 2.409919865102884E-181;
    private static final double SCALE_UP = 4.149515568880993E180;
    private static final int EXP_DIFF_THRESHOLD_2D = 54;
    private final Two two;
    private final Three three;
    private final Array array;

    private Norm(Two two, Three three, Array array) {
        this.two = two;
        this.three = three;
        this.array = array;
    }

    private Norm(Norm alias) {
        this.two = alias.two;
        this.three = alias.three;
        this.array = alias.array;
    }

    public final double of(double x, double y) {
        return this.two.of(x, y);
    }

    public final double of(double x, double y, double z) {
        return this.three.of(x, y, z);
    }

    public final double of(double[] v) {
        Norm.ensureNonEmpty(v);
        return this.array.of(v);
    }

    private static double manhattan(double x, double y) {
        return Math.abs(x) + Math.abs(y);
    }

    private static double manhattan(double x, double y, double z) {
        return Sum.of(Math.abs(x)).add(Math.abs(y)).add(Math.abs(z)).getAsDouble();
    }

    private static double manhattan(double[] v) {
        Sum sum2 = Sum.create();
        for (int i = 0; i < v.length; ++i) {
            sum2.add(Math.abs(v[i]));
        }
        return sum2.getAsDouble();
    }

    private static double euclidean(double x, double y) {
        double rescale;
        double scale;
        double min2;
        double max2;
        double yabs;
        double xabs = Math.abs(x);
        if (Double.compare(xabs, yabs = Math.abs(y)) > 0) {
            max2 = xabs;
            min2 = yabs;
        } else {
            max2 = yabs;
            min2 = xabs;
        }
        if (!Double.isFinite(max2)) {
            return xabs * yabs;
        }
        if (Math.getExponent(max2) - Math.getExponent(min2) > 54) {
            return max2;
        }
        if (max2 > 2.0458691299350887E149) {
            scale = 2.409919865102884E-181;
            rescale = 4.149515568880993E180;
        } else if (max2 < 7.888609052210118E-31) {
            scale = 4.149515568880993E180;
            rescale = 2.409919865102884E-181;
        } else {
            scale = 1.0;
            rescale = 1.0;
        }
        double sum2 = 0.0;
        double comp = 0.0;
        double sx = xabs * scale;
        double px = sx * sx;
        comp += ExtendedPrecision.squareLowUnscaled(sx, px);
        double sumPx = sum2 + px;
        comp += ExtendedPrecision.twoSumLow(sum2, px, sumPx);
        sum2 = sumPx;
        double sy = yabs * scale;
        double py = sy * sy;
        comp += ExtendedPrecision.squareLowUnscaled(sy, py);
        double sumPy = sum2 + py;
        comp += ExtendedPrecision.twoSumLow(sum2, py, sumPy);
        sum2 = sumPy;
        return Math.sqrt(sum2 + comp) * rescale;
    }

    private static double euclidean(double x, double y, double z) {
        double rescale;
        double scale;
        double xabs = Math.abs(x);
        double yabs = Math.abs(y);
        double zabs = Math.abs(z);
        double max2 = Math.max(Math.max(xabs, yabs), zabs);
        if (!Double.isFinite(max2)) {
            return xabs * yabs * zabs;
        }
        if (max2 > 2.0458691299350887E149) {
            scale = 2.409919865102884E-181;
            rescale = 4.149515568880993E180;
        } else if (max2 < 7.888609052210118E-31) {
            scale = 4.149515568880993E180;
            rescale = 2.409919865102884E-181;
        } else {
            scale = 1.0;
            rescale = 1.0;
        }
        double sum2 = 0.0;
        double comp = 0.0;
        double sx = xabs * scale;
        double px = sx * sx;
        comp += ExtendedPrecision.squareLowUnscaled(sx, px);
        double sumPx = sum2 + px;
        comp += ExtendedPrecision.twoSumLow(sum2, px, sumPx);
        sum2 = sumPx;
        double sy = yabs * scale;
        double py = sy * sy;
        comp += ExtendedPrecision.squareLowUnscaled(sy, py);
        double sumPy = sum2 + py;
        comp += ExtendedPrecision.twoSumLow(sum2, py, sumPy);
        sum2 = sumPy;
        double sz = zabs * scale;
        double pz = sz * sz;
        comp += ExtendedPrecision.squareLowUnscaled(sz, pz);
        double sumPz = sum2 + pz;
        comp += ExtendedPrecision.twoSumLow(sum2, pz, sumPz);
        sum2 = sumPz;
        return Math.sqrt(sum2 + comp) * rescale;
    }

    private static double euclidean(double[] v) {
        double s1 = 0.0;
        double s2 = 0.0;
        double s3 = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            double cs;
            double s;
            double cp;
            double p;
            double sx;
            double x = Math.abs(v[i]);
            if (!Double.isFinite(x)) {
                return Norm.euclideanNormSpecial(v, i);
            }
            if (x > 2.0458691299350887E149) {
                sx = x * 2.409919865102884E-181;
                p = sx * sx;
                cp = ExtendedPrecision.squareLowUnscaled(sx, p);
                s = s1 + p;
                cs = ExtendedPrecision.twoSumLow(s1, p, s);
                c1 += cp + cs;
                s1 = s;
                continue;
            }
            if (x < 1.4916681462400413E-154) {
                sx = x * 4.149515568880993E180;
                p = sx * sx;
                cp = ExtendedPrecision.squareLowUnscaled(sx, p);
                s = s3 + p;
                cs = ExtendedPrecision.twoSumLow(s3, p, s);
                c3 += cp + cs;
                s3 = s;
                continue;
            }
            double p2 = x * x;
            double cp2 = ExtendedPrecision.squareLowUnscaled(x, p2);
            double s4 = s2 + p2;
            double cs2 = ExtendedPrecision.twoSumLow(s2, p2, s4);
            c2 += cp2 + cs2;
            s2 = s4;
        }
        if (s1 != 0.0) {
            double s2Adj = s2 * 2.409919865102884E-181 * 2.409919865102884E-181;
            double sum2 = s1 + s2Adj;
            double comp = ExtendedPrecision.twoSumLow(s1, s2Adj, sum2) + c1 + c2 * 2.409919865102884E-181 * 2.409919865102884E-181;
            return Math.sqrt(sum2 + comp) * 4.149515568880993E180;
        }
        if (s2 != 0.0) {
            double s3Adj = s3 * 2.409919865102884E-181 * 2.409919865102884E-181;
            double sum3 = s2 + s3Adj;
            double comp = ExtendedPrecision.twoSumLow(s2, s3Adj, sum3) + c2 + c3 * 2.409919865102884E-181 * 2.409919865102884E-181;
            return Math.sqrt(sum3 + comp);
        }
        return Math.sqrt(s3 + c3) * 2.409919865102884E-181;
    }

    private static double euclideanNormSpecial(double[] v, int start2) {
        for (int i = start2; i < v.length; ++i) {
            if (!Double.isNaN(v[i])) continue;
            return Double.NaN;
        }
        return Double.POSITIVE_INFINITY;
    }

    private static double maximum(double x, double y) {
        return Math.max(Math.abs(x), Math.abs(y));
    }

    private static double maximum(double x, double y, double z) {
        return Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z)));
    }

    private static double maximum(double[] v) {
        double max2 = 0.0;
        for (int i = 0; i < v.length; ++i) {
            max2 = Math.max(max2, Math.abs(v[i]));
        }
        return max2;
    }

    private static void ensureNonEmpty(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
    }

    @FunctionalInterface
    private static interface Array {
        public double of(double[] var1);
    }

    @FunctionalInterface
    private static interface Three {
        public double of(double var1, double var3, double var5);
    }

    @FunctionalInterface
    private static interface Two {
        public double of(double var1, double var3);
    }
}

