/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.concurrency.Semaphore;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.JSDebuggerWipBackendBundle;
import org.jetbrains.wip.WipV8ProfilingHelper;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.heapprofiler.AddHeapSnapshotChunkEventData;
import org.jetbrains.wip.protocol.heapprofiler.HeapProfilerKt;
import org.jetbrains.wip.protocol.heapprofiler.ReportHeapSnapshotProgressEventData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/wip/WipV8ProfilingHelper;", "", "v8Vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "takeHeapSnapShot", "", "file", "Ljava/io/File;", "intellij.javascript.wip.backend"})
public final class WipV8ProfilingHelper {
    @NotNull
    private final WipVm v8Vm;

    public WipV8ProfilingHelper(@NotNull WipVm v8Vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)v8Vm), (String)"v8Vm");
        this.v8Vm = v8Vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nls
    @Nullable
    public final String takeHeapSnapShot(@NotNull File file) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Semaphore semaphore = new Semaphore();
        AtomicReference<String> error = new AtomicReference<String>();
        AtomicReference<Throwable> throwableRef = new AtomicReference<Throwable>();
        Closeable closeable = new BufferedOutputStream(new FileOutputStream(file));
        Throwable throwable2 = null;
        try {
            BufferedOutputStream output = (BufferedOutputStream)closeable;
            boolean bl = false;
            EventMap<ProtocolResponseReader> eventMap = this.v8Vm.getCommandProcessor().getEventMap();
            Function1 chunkHandler2 = (Function1)new Function1<AddHeapSnapshotChunkEventData, Unit>(output){
                final /* synthetic */ BufferedOutputStream $output;
                {
                    this.$output = $output;
                    super(1);
                }

                public final void invoke(@NotNull AddHeapSnapshotChunkEventData it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = it.chunk();
                    byte[] byArray = string.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    this.$output.write(byArray);
                }
            };
            eventMap.add((EventType)AddHeapSnapshotChunkEventData.TYPE, chunkHandler2);
            Function1 progressHandler2 = takeHeapSnapShot.1.progressHandler.1.INSTANCE;
            eventMap.add((EventType)ReportHeapSnapshotProgressEventData.TYPE, progressHandler2);
            semaphore.down();
            this.v8Vm.getCommandProcessor().send((Request)HeapProfilerKt.TakeHeapSnapshot$default(null, null, null, null, 15, null)).onError(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$3$lambda$0((Function1)new Function1<Throwable, Unit>(error, throwableRef){
                final /* synthetic */ AtomicReference<String> $error;
                final /* synthetic */ AtomicReference<Throwable> $throwableRef;
                {
                    this.$error = $error;
                    this.$throwableRef = $throwableRef;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    this.$error.set(JSDebuggerWipBackendBundle.message("error.taking.v8.snapshot.rejected", new Object[0]));
                    this.$throwableRef.set(it);
                }
            }, arg_0)).onError(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$3$lambda$1((Function1)new Function1<Throwable, Unit>(throwableRef){
                final /* synthetic */ AtomicReference<Throwable> $throwableRef;
                {
                    this.$throwableRef = $throwableRef;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    this.$throwableRef.set(it);
                }
            }, arg_0)).onProcessed(arg_0 -> WipV8ProfilingHelper.takeHeapSnapShot$lambda$3$lambda$2((Function1)new Function1<Unit, Unit>(eventMap, (Function1<? super AddHeapSnapshotChunkEventData, Unit>)chunkHandler2, (Function1<? super ReportHeapSnapshotProgressEventData, Unit>)progressHandler2, semaphore){
                final /* synthetic */ EventMap<ProtocolResponseReader> $eventMap;
                final /* synthetic */ Function1<AddHeapSnapshotChunkEventData, Unit> $chunkHandler;
                final /* synthetic */ Function1<ReportHeapSnapshotProgressEventData, Unit> $progressHandler;
                final /* synthetic */ Semaphore $semaphore;
                {
                    this.$eventMap = $eventMap;
                    this.$chunkHandler = $chunkHandler;
                    this.$progressHandler = $progressHandler;
                    this.$semaphore = $semaphore;
                    super(1);
                }

                public final void invoke(Unit it) {
                    this.$eventMap.remove((EventType)AddHeapSnapshotChunkEventData.TYPE, this.$chunkHandler);
                    this.$eventMap.remove((EventType)ReportHeapSnapshotProgressEventData.TYPE, this.$progressHandler);
                    this.$semaphore.up();
                }
            }, arg_0));
            if (!semaphore.waitFor(TimeUnit.MINUTES.toMillis(3L))) {
                error.set(JSDebuggerWipBackendBundle.message("error.timeout.occurred.when.saving.v8.heap.snapshot", new Object[0]));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
        }
        Throwable throwable4 = throwable = throwableRef.get();
        if (throwable4 != null) {
            throw throwable4;
        }
        String message = error.get();
        return message;
    }

    private static final void takeHeapSnapShot$lambda$3$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void takeHeapSnapShot$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void takeHeapSnapShot$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

