/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.WipMonitoringConnection;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunner;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createRunProcess", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "configuration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "enableDebuggingMode", "Lorg/jetbrains/concurrency/Promise;", "", "execute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "resolveAndroidPackageName", "resolveAndroidPackageNameInManifest", "projectPath", "runReactNative", "", "packagerProcess", "Lcom/intellij/execution/process/ProcessHandler;", "startDebugProcess", "Ljava/util/concurrent/CompletableFuture;", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "reactNativeRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof ReactNativeRunConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)"Run") || Intrinsics.areEqual((Object)executorId, (Object)"Debug"));
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration");
        ReactNativeRunConfiguration configuration = (ReactNativeRunConfiguration)runProfile;
        PackagerState startedPackager = ReactNativePackagerKt.findStartedPackager(configuration);
        CompletableFuture<Unit> packagerFuture = null;
        ProcessHandler packagerProcess = null;
        if (startedPackager != null) {
            packagerFuture = startedPackager.getReady();
            packagerProcess = startedPackager.getProcess();
        } else {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            packagerFuture = completableFuture;
            packagerProcess = null;
        }
        boolean isRun = Intrinsics.areEqual((Object)environment.getExecutor().getId(), (Object)"Run");
        AsyncPromise result = new AsyncPromise();
        ((CompletableFuture)packagerFuture.thenCompose(arg_0 -> ReactNativeProgramRunner.execute$lambda$0((Function1)new Function1<Unit, CompletionStage<RunContentDescriptor>>(isRun, configuration, this, environment, packagerProcess){
            final /* synthetic */ boolean $isRun;
            final /* synthetic */ ReactNativeRunConfiguration $configuration;
            final /* synthetic */ ReactNativeProgramRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ ProcessHandler $packagerProcess;
            {
                this.$isRun = $isRun;
                this.$configuration = $configuration;
                this.this$0 = $receiver;
                this.$environment = $environment;
                this.$packagerProcess = $packagerProcess;
                super(1);
            }

            public final CompletionStage<RunContentDescriptor> invoke(Unit it) {
                if (!this.$isRun && this.$configuration.getBuildAndLaunch()) {
                    ApplicationManager.getApplication().invokeLater(() -> execute.1.invoke$lambda$0(this.this$0, this.$environment, this.$configuration, this.$packagerProcess));
                }
                if (this.$isRun) {
                    if (!this.$configuration.getBuildAndLaunch()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    CompletableFuture<T> runContentFuture = new CompletableFuture<T>();
                    ApplicationManager.getApplication().invokeLater(() -> execute.1.invoke$lambda$1(this.this$0, this.$configuration, this.$environment, runContentFuture));
                    return runContentFuture;
                }
                return ReactNativeProgramRunner.access$startDebugProcess(this.this$0, this.$configuration, this.$environment);
            }

            private static final void invoke$lambda$0(ReactNativeProgramRunner this$0, ExecutionEnvironment $environment, ReactNativeRunConfiguration $configuration, ProcessHandler $packagerProcess) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
                Intrinsics.checkNotNullParameter((Object)((Object)$configuration), (String)"$configuration");
                ReactNativeProgramRunner.access$runReactNative(this$0, $environment, $configuration, $packagerProcess);
            }

            private static final void invoke$lambda$1(ReactNativeProgramRunner this$0, ReactNativeRunConfiguration $configuration, ExecutionEnvironment $environment, CompletableFuture $runContentFuture) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$configuration), (String)"$configuration");
                Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
                Intrinsics.checkNotNullParameter((Object)$runContentFuture, (String)"$runContentFuture");
                KillableColoredProcessHandler runHandler = ReactNativeProgramRunner.access$createRunProcess(this$0, $configuration, $environment);
                ConsoleViewImpl consoleView = new ConsoleViewImpl($environment.getProject(), false);
                consoleView.attachToProcess((ProcessHandler)runHandler);
                RunContentBuilder builder = new RunContentBuilder((ExecutionResult)new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)runHandler), $environment);
                $runContentFuture.complete(builder.showRunContent($environment.getContentToReuse()));
            }
        }, arg_0))).handle((arg_0, arg_1) -> ReactNativeProgramRunner.execute$lambda$1((Function2)new Function2<RunContentDescriptor, Throwable, Object>((AsyncPromise<RunContentDescriptor>)result){
            final /* synthetic */ AsyncPromise<RunContentDescriptor> $result;
            {
                this.$result = $result;
                super(2);
            }

            public final Object invoke(RunContentDescriptor r, Throwable t) {
                Object object;
                if (t != null) {
                    Object object2 = t.getCause();
                    if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                        object2 = "Failed to connect to bundler";
                    }
                    object = this.$result.setError((String)object2);
                } else {
                    this.$result.setResult((Object)r);
                    object = Unit.INSTANCE;
                }
                return object;
            }
        }, arg_0, arg_1));
        return (Promise)result;
    }

    private final void runReactNative(ExecutionEnvironment environment, ReactNativeRunConfiguration configuration, ProcessHandler packagerProcess) {
        KillableColoredProcessHandler runHandler = this.createRunProcess(configuration, environment);
        ConsoleView consoleView = ReactNativeProgramRunnerKt.showHelperProcessRunContent("react-native " + configuration.getPlatform().getCommandLineArgument(), (ProcessHandler)runHandler, environment);
        if (packagerProcess != null && !configuration.isHermesEngine()) {
            AtomicBoolean packagerStartedDebug = new AtomicBoolean(false);
            ProcessAdapter startDebuggerListener = null;
            startDebuggerListener = new ProcessAdapter(packagerStartedDebug, packagerProcess, environment){
                final /* synthetic */ AtomicBoolean $packagerStartedDebug;
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ExecutionEnvironment $environment;
                {
                    this.$packagerStartedDebug = $packagerStartedDebug;
                    this.$packagerProcess = $packagerProcess;
                    this.$environment = $environment;
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string = event.getText();
                    boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Starting custom debugger by executing", (boolean)false, (int)2, null) : false;
                    if (bl) {
                        this.$packagerStartedDebug.set(true);
                        this.$packagerProcess.removeProcessListener((ProcessListener)this);
                        Project project = this.$environment.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        Balloon balloon = ToolWindowManager.Companion.getInstance(project).getToolWindowBalloon("Debug");
                        if (balloon != null) {
                            ApplicationManager.getApplication().invokeLater(() -> runReactNative.1.onTextAvailable$lambda$0(balloon));
                        }
                    }
                }

                private static final void onTextAvailable$lambda$0(Balloon $balloon) {
                    $balloon.hide();
                }
            };
            packagerProcess.addProcessListener((ProcessListener)startDebuggerListener);
            Disposer.register((Disposable)((Disposable)consoleView), () -> ReactNativeProgramRunner.runReactNative$lambda$2(packagerProcess, startDebuggerListener));
            AtomicBoolean appLaunchedMessageReceived = new AtomicBoolean(false);
            runHandler.addProcessListener((ProcessListener)new ProcessAdapter(appLaunchedMessageReceived, packagerStartedDebug, this, configuration, packagerProcess, startDebuggerListener, environment){
                final /* synthetic */ AtomicBoolean $appLaunchedMessageReceived;
                final /* synthetic */ AtomicBoolean $packagerStartedDebug;
                final /* synthetic */ ReactNativeProgramRunner this$0;
                final /* synthetic */ ReactNativeRunConfiguration $configuration;
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ProcessAdapter $startDebuggerListener;
                final /* synthetic */ ExecutionEnvironment $environment;
                {
                    this.$appLaunchedMessageReceived = $appLaunchedMessageReceived;
                    this.$packagerStartedDebug = $packagerStartedDebug;
                    this.this$0 = $receiver;
                    this.$configuration = $configuration;
                    this.$packagerProcess = $packagerProcess;
                    this.$startDebuggerListener = $startDebuggerListener;
                    this.$environment = $environment;
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    block4: {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            String string = event.getText();
                            if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Starting", (boolean)false, (int)2, null) : false) break block3;
                            String string2 = event.getText();
                            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Launching", (boolean)false, (int)2, null) : false;
                            if (!bl) break block4;
                        }
                        this.$appLaunchedMessageReceived.set(true);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> runReactNative.3.processTerminated$lambda$0(this.$packagerStartedDebug, this.this$0, this.$configuration), 500L, TimeUnit.MILLISECONDS);
                    String string = this.$appLaunchedMessageReceived.get() ? JSDebuggerBundle.message((String)"react.native.runner.warning.connection.wait", (Object[])new Object[0]) : JSDebuggerBundle.message((String)"react.native.runner.warning.build.failed", (Object[])new Object[0]);
                    Intrinsics.checkNotNull((Object)string);
                    String message = string;
                    runReactNative.3.processTerminated$scheduleWarning(this.$packagerStartedDebug, this.$packagerProcess, this.$startDebuggerListener, this.$environment, message, 5L);
                }

                private static final void processTerminated$lambda$0(AtomicBoolean $packagerStartedDebug, ReactNativeProgramRunner this$0, ReactNativeRunConfiguration $configuration) {
                    Intrinsics.checkNotNullParameter((Object)$packagerStartedDebug, (String)"$packagerStartedDebug");
                    Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)((Object)$configuration), (String)"$configuration");
                    if (!$packagerStartedDebug.get()) {
                        ReactNativeProgramRunner.access$enableDebuggingMode(this$0, $configuration);
                    }
                }

                private static final void processTerminated$scheduleWarning$lambda$2$lambda$1(ExecutionEnvironment $environment, String $message) {
                    Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
                    Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                    Project project = $environment.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
                    MessageType messageType = MessageType.WARNING;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
                    toolWindowManager.notifyByBalloon("Debug", messageType, $message);
                }

                private static final void processTerminated$scheduleWarning$lambda$2(AtomicBoolean $packagerStartedDebug, ProcessHandler $packagerProcess, ProcessAdapter $startDebuggerListener, ExecutionEnvironment $environment, String $message) {
                    Intrinsics.checkNotNullParameter((Object)$packagerStartedDebug, (String)"$packagerStartedDebug");
                    Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
                    Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                    if (!$packagerStartedDebug.get()) {
                        $packagerProcess.removeProcessListener((ProcessListener)$startDebuggerListener);
                        ApplicationManager.getApplication().invokeLater(() -> runReactNative.3.processTerminated$scheduleWarning$lambda$2$lambda$1($environment, $message));
                    }
                }

                private static final void processTerminated$scheduleWarning(AtomicBoolean packagerStartedDebug, ProcessHandler $packagerProcess, ProcessAdapter startDebuggerListener, ExecutionEnvironment $environment, String message, long timeoutSec) {
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> runReactNative.3.processTerminated$scheduleWarning$lambda$2(packagerStartedDebug, $packagerProcess, startDebuggerListener, $environment, message), timeoutSec, TimeUnit.SECONDS);
                }
            });
        }
        runHandler.startNotify();
    }

    private final KillableColoredProcessHandler createRunProcess(ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        GeneralCommandLine runCommandLine = new GeneralCommandLine();
        NodeJsInterpreter nodeJsInterpreter = configuration.getNodePath().resolveNotNull(environment.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodePackage nodePackage = configuration.getReactNativePackage();
        if (nodePackage == null) {
            throw new ConfigurationException(JSDebuggerBundle.message((String)"react.native.error.invalid.react.native.path", (Object[])new Object[0]));
        }
        NodePackage reactNativePackage2 = nodePackage;
        runCommandLine.addParameter(ReactNativeProgramRunnerKt.reactNativePackageToNodeArgument(reactNativePackage2));
        runCommandLine.addParameter(configuration.getPlatform().getCommandLineArgument());
        runCommandLine.getParametersList().addParametersString(configuration.getRunArguments());
        runCommandLine.withWorkDirectory(configuration.getEffectiveWorkingDirectory());
        configuration.getEnvData().configureCommandLine(runCommandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)runCommandLine);
        NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter).configure(runCommandLine);
        return new KillableColoredProcessHandler(runCommandLine);
    }

    private final CompletableFuture<RunContentDescriptor> startDebugProcess(ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        CompletableFuture<RunContentDescriptor> result = new CompletableFuture<RunContentDescriptor>();
        AppUIUtil.invokeOnEdt(() -> ReactNativeProgramRunner.startDebugProcess$lambda$3(environment, result, configuration));
        return result;
    }

    private final Promise<Object> enableDebuggingMode(ReactNativeRunConfiguration configuration) {
        if (configuration.getPlatform() != ReactNativePlatform.ANDROID) {
            return Promises.resolvedPromise();
        }
        String packageName = this.resolveAndroidPackageName(configuration);
        GeneralCommandLine runCommandLine = new GeneralCommandLine();
        runCommandLine.setExePath("adb");
        String[] stringArray = new String[]{"shell", "am", "broadcast", "-a", packageName + ".RELOAD_APP_ACTION", "--ez", "jsproxy", "true"};
        runCommandLine.addParameters(stringArray);
        AsyncPromise result = new AsyncPromise();
        KillableProcessHandler adbProcessHandler = new KillableProcessHandler(runCommandLine);
        adbProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter((AsyncPromise<Object>)result){
            final /* synthetic */ AsyncPromise<Object> $result;
            {
                this.$result = $result;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$result.setResult(null);
            }
        });
        adbProcessHandler.startNotify();
        return (Promise)result;
    }

    private final String resolveAndroidPackageName(ReactNativeRunConfiguration configuration) {
        String effectiveWorkingDirectory = configuration.getEffectiveWorkingDirectory();
        String valueInAndroidXml = this.resolveAndroidPackageNameInManifest(effectiveWorkingDirectory);
        if (valueInAndroidXml != null) {
            return valueInAndroidXml;
        }
        String string = PathUtil.getFileName((String)effectiveWorkingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String defaultName = string;
        String string2 = ("com." + defaultName).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    private final String resolveAndroidPackageNameInManifest(String projectPath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(projectPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile workingDir = virtualFile;
        VirtualFile virtualFile2 = workingDir.findFileByRelativePath("android/app/src/main/AndroidManifest.xml");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile manifestFile = virtualFile2;
        String string = VfsUtil.loadText((VirtualFile)manifestFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
        String text = string;
        Matcher matcher = Pattern.compile("package=\"([^\"\\n]+)\"").matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static final CompletionStage execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Object execute$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0, (Object)p1);
    }

    private static final void runReactNative$lambda$2(ProcessHandler $packagerProcess, ProcessAdapter $startDebuggerListener) {
        $packagerProcess.removeProcessListener((ProcessListener)$startDebuggerListener);
    }

    private static final void startDebugProcess$lambda$3(ExecutionEnvironment $environment, CompletableFuture $result, ReactNativeRunConfiguration $configuration) {
        Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)((Object)$configuration), (String)"$configuration");
        XDebugProcessStarter starter2 = new XDebugProcessStarter($configuration){
            final /* synthetic */ ReactNativeRunConfiguration $configuration;
            {
                this.$configuration = $configuration;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                DefaultExecutionResult executionResult = new DefaultExecutionResult();
                if (this.$configuration.isHermesEngine()) {
                    HttpInetSocketAddress address = new HttpInetSocketAddress(this.$configuration.getPackagerHost(), this.$configuration.getPackagerPort());
                    WipMonitoringConnection connection2 = new WipMonitoringConnection();
                    ChromeDebugProcess process = new ChromeDebugProcess(session, (DebuggableFileFinder)new RemoteDebuggingFileFinder(null, null, 3, null), (VmConnection<? extends WipVm>)((VmConnection)connection2), (ExecutionResult)executionResult);
                    RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)address, null, (int)2, null);
                    return (XDebugProcess)process;
                }
                Url debugUrl = ReactNativeProgramRunnerKt.chromeDebugUrl(this.$configuration.getPackagerHost(), this.$configuration.getPackagerPort());
                ChromeLocalVmConnection connection3 = new ChromeLocalVmConnection(debugUrl, true, this.$configuration.getBrowser(), session);
                ChromeDebugProcess process = new ChromeDebugProcess(session, (DebuggableFileFinder)new RemoteDebuggingFileFinder(null, null, 3, null), (VmConnection<? extends WipVm>)((VmConnection)connection3), (ExecutionResult)executionResult);
                connection3.connect();
                return (XDebugProcess)process;
            }
        };
        try {
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)$environment.getProject()).startSession($environment, starter2);
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
            XDebugSession startSession = xDebugSession;
            $result.complete(startSession.getRunContentDescriptor());
        }
        catch (Throwable e) {
            $result.completeExceptionally(e);
            throw e;
        }
    }

    public static final /* synthetic */ CompletableFuture access$startDebugProcess(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        return $this.startDebugProcess(configuration, environment);
    }

    public static final /* synthetic */ void access$runReactNative(ReactNativeProgramRunner $this, ExecutionEnvironment environment, ReactNativeRunConfiguration configuration, ProcessHandler packagerProcess) {
        $this.runReactNative(environment, configuration, packagerProcess);
    }

    public static final /* synthetic */ KillableColoredProcessHandler access$createRunProcess(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        return $this.createRunProcess(configuration, environment);
    }

    public static final /* synthetic */ Promise access$enableDebuggingMode(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration) {
        return $this.enableDebuggingMode(configuration);
    }
}

