/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.table.CssTableLoaderValue;
import com.intellij.psi.css.impl.util.table.CssTableValue;
import com.intellij.psi.css.impl.util.table.CssTableValueVisitor;
import com.intellij.psi.css.impl.util.table.XmlStringWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssTableGeneratorUtil {
    @NonNls
    public static final String FILE_NAME = "propidx.html";
    @NonNls
    public static final String OUTPUT_FILE_NAME = "csstable.xml";
    @NonNls
    public static final String BASE_PATH = "../CSS/src/";
    @NonNls
    private static final List<String> mySingleTagNames = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        new CssTableGeneratorUtil().generate();
    }

    private void generate() throws IOException {
        String packagePath = this.getClass().getCanonicalName().replace('.', '/');
        File output = new File(BASE_PATH + packagePath.substring(0, packagePath.lastIndexOf(47)), OUTPUT_FILE_NAME);
        if (output.exists()) {
            output.delete();
        }
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            XmlStringWriter writer = new XmlStringWriter(osw);
            Tag rootTag = CssTableGeneratorUtil.parse(this.getClass().getResourceAsStream(FILE_NAME));
            Tag tbody = CssTableGeneratorUtil.findFirstChildTag("tbody", rootTag);
            assert (tbody != null);
            writer.addAttribute("version", "2_1");
            writer.addAttribute("generator-version", "9");
            writer.addAttribute("baseHelpRef", "http://www.w3.org/TR/CSS21/");
            writer.printlnOpeningTag("css-property-table");
            CssTableGeneratorUtil.generate(tbody, writer);
            writer.printlnClosingTag();
            writer.flush();
            osw.flush();
        }
    }

    private static void generate(@NotNull Tag tbody, final @NotNull XmlStringWriter writer) {
        if (tbody == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(1);
        }
        final ArrayList properties2 = new ArrayList();
        tbody.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                properties2.addAll(CssTableGeneratorUtil.gatherNames(t.getChildren().get(0)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$1", "fun"));
            }
        }, "tr");
        tbody.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                CssTableGeneratorUtil.proceedRow(t, properties2, writer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$2", "fun"));
            }
        }, "tr");
    }

    private static void proceedRow(@NotNull Tag row, @NotNull List<String> properties2, @NotNull XmlStringWriter writer) {
        if (row == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(2);
        }
        if (properties2 == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(3);
        }
        if (writer == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(4);
        }
        List<Tag> children = row.getChildren();
        List<String> propertyNames = CssTableGeneratorUtil.gatherNames(children.get(0));
        for (String propertyName : propertyNames) {
            writer.addAttribute("name", propertyName);
            writer.addAttribute("helpRef", CssTableGeneratorUtil.gatherHelpRef(children.get(0)));
            writer.addAttribute("initialValue", CssTableGeneratorUtil.gatherTdValue(children.get(2), null));
            writer.addAttribute("appliesTo", CssTableGeneratorUtil.gatherTdValue(children.get(3), "all"));
            writer.addAttribute("inherited", CssTableGeneratorUtil.gatherTdValue(children.get(4), null));
            writer.addAttribute("percentage", CssTableGeneratorUtil.gatherTdValue(children.get(5), "n/a"));
            writer.addAttribute("mediaGroup", CssTableGeneratorUtil.gatherMediaGroup(children.get(6)));
            writer.printlnOpeningTag("property");
            CssTableGeneratorUtil.gatherValues(propertyName, children.get(1), properties2, writer);
            writer.printlnClosingTag();
        }
    }

    private static void gatherValues(@NotNull String propertyName, @NotNull Tag td, final @NotNull List<String> properties2, @NotNull XmlStringWriter writer) {
        if (propertyName == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(5);
        }
        if (td == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(6);
        }
        if (properties2 == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(7);
        }
        if (writer == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(8);
        }
        final StringBuffer sb = new StringBuffer();
        td.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                CssTableGeneratorUtil.accumulateValue(t, properties2, sb);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$3", "fun"));
            }
        }, null);
        CssTableLoaderValue value = CssTableGeneratorUtil.processValuesList(sb.toString());
        CssTableGeneratorUtil.collapseEmptyGroups(value);
        value.write(propertyName, writer);
    }

    public static void collapseEmptyGroups(@NotNull CssTableLoaderValue value) {
        if (value == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(9);
        }
        value.accept(new CssTableValueVisitor<CssTableLoaderValue>(){

            @Override
            public void visit(@NotNull CssTableLoaderValue value) {
                if (value == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (value.isGroup()) {
                    List children = value.getChildren();
                    if (children.size() == 1) {
                        CssTableLoaderValue value1 = (CssTableLoaderValue)children.get(0);
                        if (value1.isGroup()) {
                            value.setType(value1.getType());
                            if (value.getMinCount() == -1) {
                                value.setMaxCount(value1.getMaxCount());
                                value.setMinCount(value1.getMinCount());
                            }
                            value.removeChild(value1);
                            List children1 = value1.getChildren();
                            for (CssTableLoaderValue each : children1.toArray(new CssTableLoaderValue[0])) {
                                value1.removeChild(each);
                                value.addChild(each);
                            }
                            value.accept(this);
                        }
                    } else {
                        for (CssTableLoaderValue each : value.getChildren()) {
                            each.accept(this);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$4", "visit"));
            }
        });
    }

    public static CssTableLoaderValue processValuesList(@NotNull String values) {
        if (values == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(10);
        }
        return CssTableGeneratorUtil.processValuesList(values, false);
    }

    public static CssTableLoaderValue processValuesList(@NotNull String values, boolean separateComma) {
        if (values == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(11);
        }
        CssTableLoaderValue g = new CssTableLoaderValue(CssTableValue.Type.DEFAULT);
        CssTableLoaderValue prev = null;
        StringBuffer sb = new StringBuffer();
        StringBuffer old = null;
        boolean orChar = false;
        boolean doubleOrChar = false;
        block11: for (byte ch : values.getBytes(StandardCharsets.UTF_8)) {
            char c = (char)ch;
            switch (c) {
                case '[': {
                    CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    sb = new StringBuffer();
                    g = g.addChild(new CssTableLoaderValue(CssTableValue.Type.DEFAULT));
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case ']': {
                    CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    sb = new StringBuffer();
                    prev = g;
                    g = g.getParent();
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '{': {
                    old = sb;
                    sb = new StringBuffer();
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '}': {
                    String countValue = sb.toString();
                    String[] strings = countValue.split(",");
                    assert (strings.length == 2);
                    assert (old != null);
                    CssTableLoaderValue p = CssTableGeneratorUtil.flushProperty(g, old.toString().trim(), doubleOrChar);
                    if (p != null) {
                        p.setMinCount(Integer.parseInt(strings[0]));
                        p.setMaxCount(Integer.parseInt(strings[1]));
                    } else {
                        prev.setMinCount(Integer.parseInt(strings[0]));
                        prev.setMaxCount(Integer.parseInt(strings[1]));
                    }
                    sb = new StringBuffer();
                    old = null;
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '+': {
                    CssTableLoaderValue p1 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    if (p1 != null) {
                        p1.setMinCount(1);
                        p1.setMaxCount(-1);
                    } else {
                        assert (prev != null);
                        prev.setMinCount(1);
                        prev.setMaxCount(-1);
                    }
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '*': {
                    CssTableLoaderValue p2 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    if (p2 != null) {
                        p2.setMinCount(0);
                        p2.setMaxCount(-1);
                    } else {
                        assert (prev != null);
                        prev.setMinCount(0);
                        prev.setMaxCount(-1);
                    }
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '?': {
                    CssTableLoaderValue p3 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    if (p3 != null) {
                        p3.setMinCount(0);
                        p3.setMaxCount(1);
                    } else {
                        assert (prev != null);
                        prev.setMinCount(0);
                        prev.setMaxCount(1);
                    }
                    sb = new StringBuffer();
                    orChar = false;
                    doubleOrChar = false;
                    continue block11;
                }
                case '|': {
                    CssTableLoaderValue p4 = CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
                    g.setType(CssTableValue.Type.OR);
                    if (orChar) {
                        doubleOrChar = true;
                        if (p4 != null) {
                            p4.setType(CssTableValue.Type.ANY);
                        } else {
                            g.setType(CssTableValue.Type.ANY);
                        }
                    } else {
                        doubleOrChar = false;
                    }
                    sb = new StringBuffer();
                    orChar = true;
                    continue block11;
                }
                case ',': {
                    if (separateComma) {
                        sb = new StringBuffer();
                        CssTableGeneratorUtil.flushProperty(g, ",", doubleOrChar);
                        continue block11;
                    }
                }
                default: {
                    orChar = false;
                    sb.append(c);
                }
            }
        }
        CssTableGeneratorUtil.flushProperty(g, sb.toString().trim(), doubleOrChar);
        while (g.getParent() != null) {
            g = g.getParent();
        }
        return g;
    }

    @Nullable
    private static CssTableLoaderValue flushProperty(@NotNull CssTableLoaderValue group, @NotNull String name, boolean orChar) {
        if (group == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(13);
        }
        if (!name.isEmpty()) {
            if (-1 != name.indexOf(32) && -1 == name.indexOf(40) && -1 == name.indexOf(44) && -1 == name.indexOf(47)) {
                String[] values = name.split(" ");
                CssTableLoaderValue g1 = new CssTableLoaderValue(CssTableValue.Type.DEFAULT);
                CssTableLoaderValue result = null;
                for (String value : values) {
                    result = g1.addChild(new CssTableLoaderValue(value));
                }
                group.addChild(g1);
                assert (result != null);
                return result;
            }
            if (-1 != name.indexOf(47)) {
                String[] values = name.split(" ");
                assert (values.length == 2);
                CssTableLoaderValue result = new CssTableLoaderValue(values[1]);
                result.setPrefix(values[0]);
                return group.addChild(result);
            }
            if (orChar) {
                group.setType(CssTableValue.Type.ANY);
            }
            return group.addChild(new CssTableLoaderValue(name));
        }
        return null;
    }

    private static void accumulateValue(@NotNull Tag tag, final @NotNull List<String> properties2, final @NotNull StringBuffer sb) {
        if (tag == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(14);
        }
        if (properties2 == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(15);
        }
        if (sb == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(16);
        }
        if (tag.isValueTag()) {
            Tag parent = tag.getParent();
            while (!"td".equals(parent.getName()) && !"a".equals(parent.getName())) {
                parent = parent.getParent();
            }
            String value = CssTableGeneratorUtil.stripLtGt(StringUtil.stripQuotesAroundValue((String)tag.getValue().trim()));
            if (properties2.contains(value)) {
                sb.append(' ').append(value).append("#propref");
            } else if ("a".equals(parent.getName())) {
                @NonNls String href = parent.getAttributeValue("href");
                if (href != null) {
                    if (href.contains("value-def")) {
                        sb.append(' ').append(value).append("#helpref=").append(href.substring(href.lastIndexOf(47) + 1));
                    } else if (href.contains("propdef")) {
                        sb.append(' ').append(value).append("#propref");
                    }
                }
            } else {
                sb.append(' ').append(tag.getValue());
            }
        }
        tag.for_each(new TagFunction(){

            @Override
            public void fun(@NotNull Tag t) {
                if (t == null) {
                    5.$$$reportNull$$$0(0);
                }
                CssTableGeneratorUtil.accumulateValue(t, properties2, sb);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$5", "fun"));
            }
        }, null);
    }

    @NotNull
    private static String stripLtGt(@NotNull String s) {
        if (s == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(17);
        }
        String string = s.replaceAll("&lt;([^&]+)&gt;", "$1");
        if (string == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static String gatherMediaGroup(@NotNull Tag td) {
        if (td == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(19);
        }
        Tag a = CssTableGeneratorUtil.findFirstChildTag("a", td);
        assert (a != null);
        return a.getChildren().get(0).getValue();
    }

    private static String gatherTdValue(@NotNull Tag td, @NonNls @Nullable String defValue) {
        List<Tag> children;
        if (td == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(20);
        }
        if ((children = td.getChildren()).isEmpty() && defValue != null) {
            return defValue;
        }
        return td.getChildren().get(0).getValue();
    }

    private static String gatherHelpRef(@NotNull Tag td) {
        if (td == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(21);
        }
        Tag a = CssTableGeneratorUtil.findFirstChildTag("a", td);
        assert (a != null);
        String href = a.getAttributeValue("href");
        assert (href != null);
        int index = href.lastIndexOf("/");
        return href.substring(index + 1);
    }

    private static List<String> gatherNames(@NotNull Tag td) {
        if (td == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(22);
        }
        List<Tag> spanList = CssTableGeneratorUtil.findSubTags("span", td);
        ArrayList<String> result = new ArrayList<String>();
        for (Tag span : spanList) {
            result.add(StringUtil.stripQuotesAroundValue((String)span.getChildren().get(0).getValue()));
        }
        return result;
    }

    @Nullable
    private static Tag findFirstChildTag(@NotNull @NonNls String name, @NotNull Tag root) {
        if (name == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(23);
        }
        if (root == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(24);
        }
        if (name.equals(root.getName())) {
            return root;
        }
        for (Tag child : root.getChildren()) {
            Tag tag = CssTableGeneratorUtil.findFirstChildTag(name, child);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    @NotNull
    private static List<Tag> findSubTags(@NotNull @NonNls String name, @NotNull Tag root) {
        if (name == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(25);
        }
        if (root == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(26);
        }
        if (name.equals(root.getName())) {
            ArrayList<Tag> result = new ArrayList<Tag>();
            result.add(root);
            ArrayList<Tag> arrayList = result;
            if (arrayList == null) {
                CssTableGeneratorUtil.$$$reportNull$$$0(27);
            }
            return arrayList;
        }
        ArrayList<Tag> result = new ArrayList<Tag>();
        for (Tag child : root.getChildren()) {
            List<Tag> tempList = CssTableGeneratorUtil.findSubTags(name, child);
            result.addAll(tempList);
        }
        ArrayList<Tag> arrayList = result;
        if (arrayList == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    private static Tag parse(@NotNull InputStream is) throws IOException {
        int c;
        if (is == null) {
            CssTableGeneratorUtil.$$$reportNull$$$0(29);
        }
        boolean tagStart = false;
        StringBuffer startNameBuffer = null;
        StringBuffer endNameBuffer = null;
        StringBuffer valueBuffer = null;
        StringBuffer currentBuffer = null;
        Tag current = null;
        block6: while ((c = is.read()) != -1) {
            switch ((char)c) {
                case '<': {
                    if (valueBuffer != null && current != null) {
                        String value = valueBuffer.toString().trim();
                        if (!value.isEmpty()) {
                            current.addChild(Tag.createValueTag(value));
                        }
                        valueBuffer = null;
                    }
                    tagStart = true;
                    currentBuffer = startNameBuffer = new StringBuffer();
                    continue block6;
                }
                case '>': {
                    if (startNameBuffer != null) {
                        Tag childTag = Tag.parseTag(startNameBuffer.toString());
                        if (current != null) {
                            current.addChild(childTag);
                        }
                        if (!mySingleTagNames.contains(childTag.getName())) {
                            current = childTag;
                        }
                        startNameBuffer = null;
                    } else if (endNameBuffer != null) {
                        if (current != null) {
                            String closeName = endNameBuffer.toString();
                            while (current != null && !closeName.equals(current.getName())) {
                                current = current.getParent();
                            }
                            if (current != null) {
                                current = current.getParent();
                            }
                        }
                        endNameBuffer = null;
                    }
                    currentBuffer = valueBuffer = new StringBuffer();
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\u00a0': {
                    continue block6;
                }
                case '/': {
                    if (!tagStart) break;
                    startNameBuffer = null;
                    currentBuffer = endNameBuffer = new StringBuffer();
                    continue block6;
                }
            }
            tagStart = false;
            if (currentBuffer == null) continue;
            currentBuffer.append((char)c);
        }
        return current;
    }

    static {
        mySingleTagNames.add("hr");
        mySingleTagNames.add("link");
        mySingleTagNames.add("meta");
        mySingleTagNames.add("br");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tbody";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "td";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 13: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 18: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "stripLtGt";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "proceedRow";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "gatherValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collapseEmptyGroups";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processValuesList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "flushProperty";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "accumulateValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripLtGt";
                break;
            }
            case 18: 
            case 27: 
            case 28: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "gatherMediaGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "gatherTdValue";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "gatherHelpRef";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "gatherNames";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findFirstChildTag";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findSubTags";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 27, 28 -> new IllegalStateException(string);
        };
    }

    private static final class Tag {
        private Tag myParent;
        private final Map<String, String> myAttributes;
        private final List<Tag> myChildren;
        private String myValue;
        private String myName;

        private Tag(@NotNull String name) {
            if (name == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myAttributes = new HashMap<String, String>();
            this.myChildren = new ArrayList<Tag>();
            this.myName = name;
        }

        private Tag() {
            this.myAttributes = new HashMap<String, String>();
            this.myChildren = new ArrayList<Tag>();
        }

        public static Tag createValueTag(@NotNull String s) {
            if (s == null) {
                Tag.$$$reportNull$$$0(1);
            }
            Tag tag = new Tag();
            tag.setValue(s);
            return tag;
        }

        public static Tag parseTag(@NotNull String s) {
            if (s == null) {
                Tag.$$$reportNull$$$0(2);
            }
            StringTokenizer tokenizer = new StringTokenizer(s);
            Tag result = new Tag(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String pair = tokenizer.nextToken();
                int eqNdx = pair.indexOf(61);
                if (eqNdx != -1) {
                    result.addAttribute(pair.substring(0, eqNdx), StringUtil.stripQuotesAroundValue((String)pair.substring(eqNdx + 1)));
                    continue;
                }
                result.addAttribute(pair, null);
            }
            return result;
        }

        public void for_each(@NotNull TagFunction func, @NonNls @Nullable String nameFilter) {
            if (func == null) {
                Tag.$$$reportNull$$$0(3);
            }
            for (Tag tag : this.getChildren()) {
                if (nameFilter != null && !nameFilter.equals(tag.getName())) continue;
                func.fun(tag);
            }
        }

        @NonNls
        public String getName() {
            return this.myName;
        }

        public void addAttribute(@NotNull String name, @Nullable String value) {
            if (name == null) {
                Tag.$$$reportNull$$$0(4);
            }
            this.myAttributes.put(name, value);
        }

        public void setParent(Tag parent) {
            this.myParent = parent;
        }

        public void addChild(@NotNull Tag child) {
            if (child == null) {
                Tag.$$$reportNull$$$0(5);
            }
            this.myChildren.add(child);
            child.setParent(this);
        }

        public void setValue(String value) {
            this.myValue = value;
        }

        @NotNull
        public List<Tag> getChildren() {
            List<Tag> list = this.myChildren;
            if (list == null) {
                Tag.$$$reportNull$$$0(6);
            }
            return list;
        }

        public String getValue() {
            return this.myValue;
        }

        public Tag getParent() {
            return this.myParent;
        }

        public boolean isValueTag() {
            return this.myValue != null;
        }

        @Nullable
        public String getAttributeValue(@NonNls @NotNull String name) {
            if (name == null) {
                Tag.$$$reportNull$$$0(7);
            }
            return this.myAttributes.get(name);
        }

        public String toString() {
            if (this.myName == null) {
                return this.myValue;
            }
            StringBuilder result = new StringBuilder(this.getName());
            if (!this.myAttributes.isEmpty()) {
                result.append(" [");
                for (String key : this.myAttributes.keySet()) {
                    result.append(" ").append(key).append("=").append(this.myAttributes.get(key));
                }
                result.append("]");
            }
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "func";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssTableGeneratorUtil$Tag";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createValueTag";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTag";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "for_each";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addAttribute";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addChild";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    static interface TagFunction {
        public void fun(@NotNull Tag var1);
    }
}

