/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.jetbrains.lang.makefile.MakefileCodeStyleSettings;
import com.jetbrains.lang.makefile.MakefileLangBundle;
import com.jetbrains.lang.makefile.MakefileLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/lang/makefile/MakefileCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsProvider;", "()V", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "getLanguage", "Lcom/intellij/lang/Language;", "intellij.makefile"})
public final class MakefileCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        String string = MakefileLangBundle.message("configurable.name", new Object[0]);
        return (CodeStyleConfigurable)new CodeStyleAbstractConfigurable(settings, modelSettings, string){

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                MakefileLanguage makefileLanguage = MakefileLanguage.INSTANCE;
                CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
                return (CodeStyleAbstractPanel)new TabbedLanguageCodeStylePanel(settings, makefileLanguage, codeStyleSettings){

                    protected void initTabs(@NotNull CodeStyleSettings settings) {
                        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                        this.addIndentOptionsTab(settings);
                    }
                };
            }

            @Nullable
            public String getHelpTopic() {
                return null;
            }
        };
    }

    @NotNull
    public Language getLanguage() {
        return MakefileLanguage.INSTANCE;
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new MakefileCodeStyleSettings(settings);
    }
}

