/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.fileEditors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorComposite;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.PsiAwareFileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.fileEditor.FileEntry;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.vfs.IProtocolVirtualFile;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.fileEditors.FrontendFileEditorHost;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J$\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0017J$\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002JG\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00112\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150$H\u0000\u00a2\u0006\u0002\b%R$\u0010\u0007\u001a\u0018\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager;", "Lcom/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "request", "Lcom/jetbrains/rd/util/Boxed;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "canOpenFile", "", "file", "canOpenFileAsync", "providers", "", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeFile", "", "composite", "closeFile$intellij_rd_client", "createCompositeAndModel", "window", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "fileEntry", "Lcom/intellij/platform/fileEditor/FileEntry;", "getWindow", "openFileFromBackend", "editorsWithProviders", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "requestFocus", "selectAsCurrent", "initialize", "Lkotlin/Function1;", "openFileFromBackend$intellij_rd_client", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendFileEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n65#2,4:150\n65#2,4:158\n65#2,4:162\n65#2,4:167\n65#2,4:172\n65#2,4:180\n65#2,4:189\n65#2,4:194\n13#2:198\n55#3,4:154\n61#3:166\n55#3,4:176\n61#3:184\n55#3,4:185\n61#3:193\n1#4:171\n*S KotlinDebug\n*F\n+ 1 FrontendFileEditorManager.kt\ncom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager\n*L\n43#1:150,4\n52#1:158,4\n55#1:162,4\n58#1:167,4\n79#1:172,4\n90#1:180,4\n104#1:189,4\n116#1:194,4\n31#1:198\n50#1:154,4\n50#1:166\n89#1:176,4\n89#1:184\n103#1:185,4\n103#1:193\n*E\n"})
public class FrontendFileEditorManager
extends PsiAwareFileEditorManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Boxed<Pair<VirtualFile, EditorComposite>> request;
    @NotNull
    private static final Logger LOG;

    public FrontendFileEditorManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public EditorComposite createCompositeAndModel(@NotNull VirtualFile file, @NotNull EditorWindow window, @Nullable FileEntry fileEntry) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] createComposite called. file.name=" + file.getName() + ", isEdt=" + SwingUtilities.isEventDispatchThread());
        }
        if (!(file instanceof IProtocolVirtualFile)) {
            return super.createCompositeAndModel(file, window, fileEntry);
        }
        if (this.request == null) {
            void flag$iv;
            $this$trace$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(@Nullable Object value) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value);
                }
            };
            Boxed value$iv = new Boxed((Object)TuplesKt.to((Object)file, null));
            boolean $i$f$usingFlag = false;
            Object old$iv = flag$iv.get();
            try {
                RdFileEditorCompositeId rdFileEditorCompositeId;
                Logger logger;
                flag$iv.set((Object)value$iv);
                boolean bl = false;
                LOG.warn("Synchronously waiting for editor for " + file);
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl2 = false;
                    logger.trace("[file] createComposite: Synchronously waiting for editor (start)");
                }
                if (FrontendFileEditorHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(this.getProject())).requestCompositeFromBackendSync(((IProtocolVirtualFile)file).getFileId(), this.getProject()) == null) {
                    FrontendFileEditorManager $this$createCompositeAndModel_u24lambda_u246_u24lambda_u243 = this;
                    boolean bl3 = false;
                    Logger $this$trace$iv3 = LOG;
                    boolean $i$f$trace3 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        Logger logger2 = $this$trace$iv3;
                        boolean bl4 = false;
                        logger2.trace("[file] createComposite: Synchronously waiting for editor (finish with failure)). compositeId=null");
                    }
                    EditorComposite editorComposite = null;
                    return editorComposite;
                }
                RdFileEditorCompositeId compositeId = rdFileEditorCompositeId;
                Logger $this$trace$iv4 = LOG;
                boolean $i$f$trace4 = false;
                if ($this$trace$iv4.isTraceEnabled()) {
                    logger = $this$trace$iv4;
                    boolean bl5 = false;
                    logger.trace("[file] createComposite: Synchronously waiting for editor (finish with success)). compositeId=" + compositeId);
                }
                Boxed<Pair<VirtualFile, EditorComposite>> boxed = this.request;
                Intrinsics.checkNotNull(boxed);
                Pair pair = (Pair)boxed.getValue();
                VirtualFile currentFile = (VirtualFile)pair.component1();
                EditorComposite currentComposite = (EditorComposite)pair.component2();
                boolean bl6 = Intrinsics.areEqual((Object)currentFile, (Object)file);
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl7 = false;
                    String string = "File mismatch after sync wait: expected: " + file + ", actual: " + currentFile;
                    throw new AssertionError((Object)string);
                }
                EditorComposite editorComposite = currentComposite;
                return editorComposite;
            }
            finally {
                flag$iv.set(old$iv);
            }
        }
        Boxed<Pair<VirtualFile, EditorComposite>> boxed = this.request;
        Intrinsics.checkNotNull(boxed);
        Pair pair = (Pair)boxed.getValue();
        VirtualFile currentFile = (VirtualFile)pair.component1();
        EditorComposite currentComposite = (EditorComposite)pair.component2();
        boolean bl = Intrinsics.areEqual((Object)currentFile, (Object)file);
        if (_Assertions.ENABLED && !bl) {
            boolean bl8 = false;
            String string = "File mismatch on backend open: expected: " + file + ", actual: " + currentFile;
            throw new AssertionError((Object)string);
        }
        return currentComposite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void openFileFromBackend$intellij_rd_client(@NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders, boolean requestFocus, boolean selectAsCurrent, @NotNull Function1<? super EditorComposite, Unit> initialize2) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
        Intrinsics.checkNotNullParameter(initialize2, (String)"initialize");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("[file] openFileFromBackend called. file.name=" + file.getName());
        }
        Flow flow = this.createCompositeModelByProvidedList(editorsWithProviders);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        EditorComposite editorComposite = super.createCompositeByEditorWithModel(file, flow, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)string, null, (boolean)false, (int)6, null));
        Intrinsics.checkNotNull((Object)editorComposite);
        EditorComposite composite = editorComposite;
        initialize2.invoke((Object)composite);
        Boxed<Pair<VirtualFile, EditorComposite>> currentRequest = this.request;
        if (currentRequest == null) {
            void flag$iv;
            KMutableProperty0 bl = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                @Nullable
                public Object get() {
                    return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                }

                public void set(@Nullable Object value) {
                    FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value);
                }
            };
            Boxed value$iv = new Boxed((Object)TuplesKt.to((Object)composite.getFile(), (Object)composite));
            boolean $i$f$usingFlag = false;
            Object old$iv = flag$iv.get();
            try {
                flag$iv.set((Object)value$iv);
                boolean bl2 = false;
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv2;
                    boolean bl3 = false;
                    logger2.trace("[file] openFileFromBackend: currentRequest is null. Call openFile(...)");
                }
                FileEditorComposite fileEditorComposite = this.openFile(composite.getFile(), null, new FileEditorOpenOptions(selectAsCurrent, false, false, requestFocus, false, 0, false, null, false, false, 1012, null));
            }
            finally {
                flag$iv.set(old$iv);
            }
        } else {
            Pair pair = (Pair)currentRequest.getValue();
            VirtualFile currentFile = (VirtualFile)pair.component1();
            EditorComposite currentComposite = (EditorComposite)pair.component2();
            if (!Intrinsics.areEqual((Object)currentFile, (Object)composite.getFile())) {
                void flag$iv;
                KMutableProperty0 old$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

                    @Nullable
                    public Object get() {
                        return FrontendFileEditorManager.access$getRequest$p((FrontendFileEditorManager)((Object)this.receiver));
                    }

                    public void set(@Nullable Object value) {
                        FrontendFileEditorManager.access$setRequest$p((FrontendFileEditorManager)((Object)this.receiver), (Boxed)value);
                    }
                };
                Boxed value$iv = new Boxed((Object)TuplesKt.to((Object)composite.getFile(), (Object)composite));
                boolean $i$f$usingFlag = false;
                Object old$iv2 = flag$iv.get();
                try {
                    flag$iv.set((Object)value$iv);
                    boolean bl = false;
                    Logger $this$trace$iv3 = LOG;
                    boolean $i$f$trace3 = false;
                    if ($this$trace$iv3.isTraceEnabled()) {
                        Logger logger3 = $this$trace$iv3;
                        boolean bl4 = false;
                        logger3.trace("[file] openFileFromBackend: currentRequest is not null, but `request.value.first != composite.file`. Call openFile(...). currentRequest.value=" + currentRequest.getValue() + ", composite.file=" + composite.getFile());
                    }
                    FileEditorComposite fileEditorComposite = this.openFile(composite.getFile(), null, new FileEditorOpenOptions(false, false, false, requestFocus, false, 0, false, null, false, false, 1013, null));
                }
                finally {
                    flag$iv.set(old$iv2);
                }
            } else {
                boolean bl;
                Logger $this$trace$iv4 = LOG;
                boolean $i$f$trace4 = false;
                if ($this$trace$iv4.isTraceEnabled()) {
                    logger = $this$trace$iv4;
                    boolean bl5 = false;
                    logger.trace("[file] openFileFromBackend: request is nit null. DO NOT call openFile(...), just put `composite` into `request`.");
                }
                boolean bl6 = bl = currentComposite == null;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                currentRequest.setValue((Object)TuplesKt.to((Object)composite.getFile(), (Object)composite));
                return;
            }
        }
    }

    public final void closeFile$intellij_rd_client(@NotNull EditorComposite composite) {
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        EditorWindow editorWindow = this.getWindow(composite);
        if (editorWindow == null) {
            return;
        }
        EditorWindow window = editorWindow;
        this.closeFile(composite.getFile(), window);
    }

    private final EditorWindow getWindow(EditorComposite composite) {
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            for (EditorWindow window : splitters.windows()) {
                if (!Intrinsics.areEqual((Object)window.getComposite(composite.getFile()), (Object)composite)) continue;
                return window;
            }
        }
        return null;
    }

    public boolean canOpenFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof IProtocolVirtualFile || super.canOpenFile(file);
    }

    @Nullable
    protected Object canOpenFileAsync(@NotNull VirtualFile file, @NotNull List<? extends FileEditorProvider> providers, @NotNull Continuation<? super Boolean> $completion) {
        return FrontendFileEditorManager.canOpenFileAsync$suspendImpl(this, file, providers, $completion);
    }

    static /* synthetic */ Object canOpenFileAsync$suspendImpl(FrontendFileEditorManager $this, VirtualFile file, List<? extends FileEditorProvider> providers, Continuation<? super Boolean> $completion) {
        if (!(file instanceof IProtocolVirtualFile)) {
            return super.canOpenFileAsync(file, providers, $completion);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    public static final /* synthetic */ Boxed access$getRequest$p(FrontendFileEditorManager $this) {
        return $this.request;
    }

    public static final /* synthetic */ void access$setRequest$p(FrontendFileEditorManager $this, Boxed boxed) {
        $this.request = boxed;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendFileEditorManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/fileEditors/FrontendFileEditorManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendFileEditorManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.jetbrains.rdclient.fileEditors.FrontendFileEditorManager");
            return (FrontendFileEditorManager)fileEditorManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

