/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.actions.base;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.ide.model.ActionAesthetics;
import com.jetbrains.rd.ui.actions.PossiblyDelegatingToBackendAction;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.BackendActionTrait;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListener;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListenerKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateInterceptor;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/actions/base/BackendAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/OverridingAction;", "Lcom/jetbrains/rdclient/actions/base/BackendActionTrait;", "Lcom/jetbrains/rd/ui/actions/PossiblyDelegatingToBackendAction;", "backendActionId", "", "requirements", "Lcom/jetbrains/rd/actions/AccessRequirements;", "aesthetics", "Lcom/jetbrains/rd/ide/model/ActionAesthetics;", "(Ljava/lang/String;Lcom/jetbrains/rd/actions/AccessRequirements;Lcom/jetbrains/rd/ide/model/ActionAesthetics;)V", "getBackendActionId", "()Ljava/lang/String;", "getRequirements", "()Lcom/jetbrains/rd/actions/AccessRequirements;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "beforeActionPerformedUpdate", "beforeDelegatingToBackend", "displayTextInToolbar", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isDumbAware", "update", "useSmallerFontForTextInToolbar", "intellij.rd.client"})
public class BackendAction
extends AnAction
implements OverridingAction,
BackendActionTrait,
PossiblyDelegatingToBackendAction {
    @NotNull
    private final String backendActionId;
    @Nullable
    private final AccessRequirements requirements;
    @Nullable
    private final ActionAesthetics aesthetics;

    public BackendAction(@NotNull String backendActionId, @Nullable AccessRequirements requirements, @Nullable ActionAesthetics aesthetics) {
        Intrinsics.checkNotNullParameter((Object)backendActionId, (String)"backendActionId");
        this.backendActionId = backendActionId;
        this.requirements = requirements;
        this.aesthetics = aesthetics;
    }

    public /* synthetic */ BackendAction(String string, AccessRequirements accessRequirements, ActionAesthetics actionAesthetics, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            accessRequirements = null;
        }
        if ((n & 4) != 0) {
            actionAesthetics = null;
        }
        this(string, accessRequirements, actionAesthetics);
    }

    @NotNull
    public final String getBackendActionId() {
        return this.backendActionId;
    }

    @Nullable
    public final AccessRequirements getRequirements() {
        return this.requirements;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isDumbAware() {
        return true;
    }

    public boolean displayTextInToolbar() {
        ActionAesthetics actionAesthetics = this.aesthetics;
        return actionAesthetics != null ? actionAesthetics.getDisplayTextInToolbar() : super.displayTextInToolbar();
    }

    public boolean useSmallerFontForTextInToolbar() {
        ActionAesthetics actionAesthetics = this.aesthetics;
        return actionAesthetics != null ? actionAesthetics.getUseSmallerFontForTextInToolbar() : super.useSmallerFontForTextInToolbar();
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (FrontendActionUpdateInterceptor.Companion.isNewActionUpdateEnabled()) {
            return;
        }
        super.beforeActionPerformedUpdate(e);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (FrontendActionUpdateInterceptor.Companion.isNewActionUpdateEnabled()) {
            throw new UnsupportedOperationException(this.getClass().getName() + "#update (" + this.backendActionId + ")");
        }
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            BackendActionDelegationKt.backendAsyncUpdatePresentation(this.backendActionId, this, e);
        }
    }

    public void beforeDelegatingToBackend() {
        Object object = ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendActionExecutionListener.Companion.getTOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        FrontendActionExecutionListenerKt.beforeActionExecutedOnBackend((FrontendActionExecutionListener)object, this.backendActionId);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.beforeDelegatingToBackend();
        BackendActionDelegationKt.backendActionPerformed(this.backendActionId, e);
    }
}

