/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.util.MarkdownPluginScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "()V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "setHideErrors", "hideErrors", "startInWriteAction", "CodeAnalyzerRestartListener", "intellij.markdown"})
public final class MarkdownCodeFenceErrorHighlightingIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.hide.problems.intention.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
        PsiFile psiFile;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiFile psiFile2 = file;
                if (!Intrinsics.areEqual((Object)(psiFile2 != null ? psiFile2.getFileType() : null), (Object)((Object)MarkdownFileType.INSTANCE)) || !MarkdownSettings.Companion.getInstance(project).getShowProblemsInCodeBlocks()) {
                    return false;
                }
                psiFile = file;
                if (psiFile == null) break block5;
                Editor editor3 = editor2;
                if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) {
                    return false;
                }
                if ((psiFile = psiFile.findElementAt(editor3.getOffset())) != null) break block6;
            }
            return false;
        }
        PsiFile element2 = psiFile;
        return PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownCodeFence.class) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setHideErrors(project, true);
        NotificationGroup notificationGroup = MarkdownNotifications.INSTANCE.getGroup();
        String string = MarkdownBundle.message("markdown.hide.problems.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = MarkdownBundle.message("markdown.hide.problems.notification.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION);
        String string3 = MarkdownBundle.message("markdown.hide.problems.notification.rollback.action.text", new Object[0]);
        notification.addAction((AnAction)new NotificationAction(this, project, string3){
            final /* synthetic */ MarkdownCodeFenceErrorHighlightingIntention this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                MarkdownCodeFenceErrorHighlightingIntention.access$setHideErrors(this.this$0, this.$project, false);
                notification.expire();
            }
        });
        notification.notify(project);
    }

    private final void setHideErrors(Project project, boolean hideErrors) {
        MarkdownSettings.Companion.getInstance(project).update((Function1<? super MarkdownSettings, Unit>)((Function1)new Function1<MarkdownSettings, Unit>(hideErrors){
            final /* synthetic */ boolean $hideErrors;
            {
                this.$hideErrors = $hideErrors;
                super(1);
            }

            public final void invoke(@NotNull MarkdownSettings it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                it.setShowProblemsInCodeBlocks(!this.$hideErrors);
            }
        }));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static final /* synthetic */ void access$setHideErrors(MarkdownCodeFenceErrorHighlightingIntention $this, Project project, boolean hideErrors) {
        $this.setHideErrors(project, hideErrors);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceErrorHighlightingIntention$CodeAnalyzerRestartListener;", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings$ChangeListener;", "()V", "settingsChanged", "", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownSettings;", "intellij.markdown"})
    public static final class CodeAnalyzerRestartListener
    implements MarkdownSettings.ChangeListener {
        @Override
        public void settingsChanged(@NotNull MarkdownSettings settings) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            Project project = settings.getProject$intellij_markdown();
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            if (fileEditorManager == null) {
                return;
            }
            FileEditorManager editorManager = fileEditorManager;
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
            if (daemonCodeAnalyzer == null) {
                return;
            }
            DaemonCodeAnalyzer codeAnalyzer = daemonCodeAnalyzer;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            CoroutineScope coroutineScope = MarkdownPluginScope.Companion.scope(project);
            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editorManager, psiManager2, codeAnalyzer, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FileEditorManager $editorManager;
                final /* synthetic */ PsiManager $psiManager;
                final /* synthetic */ DaemonCodeAnalyzer $codeAnalyzer;
                {
                    this.$editorManager = $editorManager;
                    this.$psiManager = $psiManager;
                    this.$codeAnalyzer = $codeAnalyzer;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            this.label = 1;
                            Object object3 = CoroutinesKt.readAction((Function0)((Function0)new Function0<Unit>(this.$editorManager, $this$launch, this.$psiManager, this.$codeAnalyzer){
                                final /* synthetic */ FileEditorManager $editorManager;
                                final /* synthetic */ CoroutineScope $$this$launch;
                                final /* synthetic */ PsiManager $psiManager;
                                final /* synthetic */ DaemonCodeAnalyzer $codeAnalyzer;
                                {
                                    this.$editorManager = $editorManager;
                                    this.$$this$launch = $$this$launch;
                                    this.$psiManager = $psiManager;
                                    this.$codeAnalyzer = $codeAnalyzer;
                                    super(0);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke() {
                                    void $this$filterTo$iv$iv;
                                    VirtualFile[] virtualFileArray = this.$editorManager.getOpenFiles();
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
                                    Object[] $this$filter$iv = virtualFileArray;
                                    boolean $i$f$filter = false;
                                    Object[] objectArray = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                                        VirtualFile it = (VirtualFile)element$iv$iv;
                                        boolean bl = false;
                                        Intrinsics.checkNotNull((Object)it);
                                        if (!MarkdownLanguageUtilsKt.hasMarkdownType(it)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    List files = (List)destination$iv$iv;
                                    for (VirtualFile file : files) {
                                        PsiFile psi;
                                        if (!file.isValid()) {
                                            CoroutineScope $this$thisLogger$iv = this.$$this$launch;
                                            boolean $i$f$thisLogger = false;
                                            Logger logger = Logger.getInstance(CoroutineScope.class);
                                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                            logger.warn("Virtual file " + file + " is not valid");
                                            continue;
                                        }
                                        if (this.$psiManager.findFile(file) == null) continue;
                                        this.$codeAnalyzer.restart(psi);
                                    }
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }
}

